package com.biz.crm.dms.business.contract.local.repository.contractliability;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractliability.ContractLiability;
import com.biz.crm.dms.business.contract.local.mapper.contractliability.ContractLiabilityMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 合同违约责任
 * @author: rentao
 * @date: 2021/11/22 16:19
 */
@Component
public class ContractLiabilityRepository
    extends ServiceImpl<ContractLiabilityMapper, ContractLiability> {

  /**
   * 通过合同编码查询合同违约责任
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  public ContractLiability findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractLiability::getContractCode, contractcode).one();
  }
}
