package com.biz.crm.dms.business.contract.local.repository.contractsignbar;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractsignbar.ContractSignBar;
import com.biz.crm.dms.business.contract.local.mapper.contractsignbar.ContractSignBarMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 合同签署栏
 * @author: rentao
 * @date: 2021/11/24 10:17
 */
@Component
public class ContractSignBarRepository extends ServiceImpl<ContractSignBarMapper, ContractSignBar> {

  /**
   * 通过合同编码查询合同签署栏
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  public ContractSignBar findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractSignBar::getContractCode, contractcode).one();
  }
}
