package com.biz.crm.dms.business.contract.local.repository.contracttemplate;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.mapper.contracttemplate.ContractTemplateMapper;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;

/**
 * @description: 合同模板 的 数据库访问类 {@link ContractTemplate}
 * @author: rentao
 * @date: 2021/11/16 14:00
 */
@Component
public class ContractTemplateRepository
    extends ServiceImpl<ContractTemplateMapper, ContractTemplate> {

  /**
   * 分页条件查询客户物料
   *
   * @param pageable 分页信息
   * @param dto 查询筛选条件
   * @return 分页数据
   */
  public Page<ContractTemplate> findByConditions(
      Page<ContractTemplate> pageable, @Param("dto") ContractTemplateDto dto) {
    return this.baseMapper.findByConditions(pageable, dto);
  }

  /**
   * 编码查询查询合同模板
   *
   * @param code 合同模板编码
   * @return 分页数据
   */
  public ContractTemplate findByContractTemplateCode(String code) {
    if (StringUtils.isBlank(code)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(ContractTemplate::getTemplateCode, code)
        .eq(ContractTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ContractTemplate::getTenantCode, TenantUtils.getTenantCode())
        .one();
  }

  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.lambdaUpdate()
        .set(ContractTemplate::getEnableStatus, enable.getCode())
        .in(ContractTemplate::getId, ids)
        .update();
  }

  /**
   * 通过名称查询 不等于此id 合同模板
   *
   * @param name 模板名称
   * @param id 模板id
   * @author rentao
   * @date
   */
  public List<ContractTemplate> findByContractTemplateInIds(String name, String id) {
    if (StringUtils.isBlank(name)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(ContractTemplate::getTemplateName, name)
        .eq(ContractTemplate::getTenantCode, TenantUtils.getTenantCode())
        .ne(StringUtils.isNotEmpty(id), ContractTemplate::getId, id)
        .list();
  }

  /**
   * 合同模板编码批量查询合同模板
   *
   * @param templateCodes
   * @author rentao
   * @date a
   */
  public List<ContractTemplate> findByTemplateCodes(Set<String> templateCodes) {
    if (CollectionUtils.isEmpty(templateCodes)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(ContractTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ContractTemplate::getEnableStatus, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ContractTemplate::getTenantCode, TenantUtils.getTenantCode())
        .in(ContractTemplate::getTemplateCode, templateCodes)
        .list();
  }

  /**
   * 删除模板
   * @param delete
   * @param ids
   */
  public void updateDelFlagStatusByIdIn(DelFlagStatusEnum delete, List<String> ids) {
    this.lambdaUpdate()
            .set(ContractTemplate::getDelFlag, delete.getCode())
            .in(ContractTemplate::getId, ids)
            .update();
  }
}
