package com.biz.crm.dms.business.contract.local.repository.contracttemplateelement;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contracttemplateelement.ContractTemplateElement;
import com.biz.crm.dms.business.contract.local.mapper.contracttemplateelement.ContractTemplateElementMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 合同模板要素映射 的 数据库访问类 {@link ContractTemplateElement}
 * @author: rentao
 * @date: 2021/11/18 14:30
 */
@Component
public class ContractTemplateElementRepository
    extends ServiceImpl<ContractTemplateElementMapper, ContractTemplateElement> {

  /**
   * 合同模板编码查询 对应要素映射
   *
   * @param templateCode
   */
  public List<ContractTemplateElement> findByContractTemplateCode(String templateCode) {
    if (StringUtils.isBlank(templateCode)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(ContractTemplateElement::getTemplateCode, templateCode)
        .orderByAsc(ContractTemplateElement::getIndexCode)
        .list();
  }

  /** 合同模板编码删除映射关系 */
  public void deleteBytemplateCode(String templateCode) {
    this.lambdaUpdate().eq(ContractTemplateElement::getTemplateCode, templateCode).remove();
  }
}
