package com.biz.crm.dms.business.contract.local.service.contract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @description: 合同service
 * @author: rentao
 * @date: 2021/11/16 14:28
 */
public interface ContractService {

  /**
   * 新增合同
   *
   * @param contractDto
   * @return
   */
  Contract create(ContractDto contractDto);

  /**
   * 编辑合同
   *
   * @param contractDto
   * @return
   */
  Contract update(ContractDto contractDto);

  /**
   * 分页条件查询合同
   *
   * @param pageable 分页参数
   * @param dto 客户物料查询参数
   * @return 客户物料实体
   */
  Page<Contract> findByConditions(Pageable pageable, ContractDto dto);

  /**
   * 批量启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 合同签署
   *
   * @param contractCode
   */
  void signContract(String contractCode);

  /**
   * 合同作废
   *
   * @param contractCode
   */
  void cancellation(String contractCode);

  /**
   * 合同推送
   *
   * @param contractCode
   */
  void handlePush(String contractCode);

  /**
   * 合同过期（定时任务）
   *
   */
  void expire();

  /**
   * 合同生效（定时任务）
   *
   */
  void effective();

  /**
   * 合同到期提醒（定时任务）
   *
   */
  void expireEminder();
}
