package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.contract.local.entity.contract.ContractAdditionalFile;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractAdditionalFileRepository;
import com.biz.crm.dms.business.contract.local.service.contract.ContractAdditionalFileService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractAdditionalFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 合同附加文件表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-17 11:23:53
 */
@Slf4j
@Service("contractAdditionalFileService")
public class ContractAdditionalFileServiceImpl implements ContractAdditionalFileService {

  @Autowired
  private ContractAdditionalFileRepository contractAdditionalFileRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Override
  @Transactional
  public void create(List<ContractAdditionalFileDto> dtoList) {
    this.createValidation(dtoList);
    List<ContractAdditionalFile> fileList = Lists.newArrayList();
    Set<String> contractIds = dtoList.stream().map(ContractAdditionalFileDto::getContractId).collect(Collectors.toSet());
    this.contractAdditionalFileRepository.deleteByContractIds(contractIds);
    dtoList.forEach(typeFileDto -> {
      if (CollectionUtils.isEmpty(typeFileDto.getFileList())) {
        return;
      }
      typeFileDto.getFileList().forEach(fileDto -> {
        ContractAdditionalFile file = this.nebulaToolkitService.copyObjectByBlankList(fileDto, ContractAdditionalFile.class, HashSet.class, ArrayList.class);
        file.setContractId(typeFileDto.getContractId());
        file.setFileType(typeFileDto.getFileType());
        file.setAdditionalFileCode(this.generateCodeService.generateCode("CAF", 1).get(0));
        file.setTenantCode(typeFileDto.getTenantCode());
        file.setSortIndex(typeFileDto.getFileList().indexOf(fileDto));
        fileList.add(file);
      });
    });
    if (!CollectionUtils.isEmpty(fileList)) {
      this.contractAdditionalFileRepository.saveBatch(fileList);
    }
  }

  /**
   * 在创建ContractAdditionalFile模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dtoList 检查对象
   */
  private void createValidation(List<ContractAdditionalFileDto> dtoList) {
    Validate.isTrue(!CollectionUtils.isEmpty(dtoList), "进行当前操作时，信息对象必须传入!");
    dtoList.forEach(typeFileDto -> {
      Validate.notBlank(typeFileDto.getContractId(), "缺失合同ID");
      Validate.notBlank(typeFileDto.getFileType(), "缺失文件类型");
      typeFileDto.setTenantCode(TenantUtils.getTenantCode());
      if (!CollectionUtils.isEmpty(typeFileDto.getFileList())) {
        typeFileDto.getFileList().forEach(fileDto -> {
          Validate.notBlank(fileDto.getAdditionalTypeKey(), "缺失附加类型key");
        });
      }
    });
  }
}
