package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.biz.crm.dms.business.contract.sdk.register.contract.ContractAdditionalFileRegister;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileTypeVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileTypeVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 合同附加类型Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Slf4j
@Service
public class ContractAdditionalFileTypeVoServiceImpl implements ContractAdditionalFileTypeVoService {

  @Autowired(required = false)
  private List<ContractAdditionalFileRegister> registers;

  @Override
  public List<ContractAdditionalFileTypeVo> findAll() {
    if (CollectionUtils.isEmpty(registers)) {
      return Lists.newLinkedList();
    }
    return this.registers.stream().map(register -> {
      ContractAdditionalFileTypeVo typeVo = new ContractAdditionalFileTypeVo();
      typeVo.setAdditionalTypeKey(register.getAdditionalTypeKey());
      typeVo.setAdditionalTypeName(register.getAdditionalTypeName());
      return typeVo;
    }).collect(Collectors.toList());
  }
}
