package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.contract.local.entity.contract.ContractAdditionalFile;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractAdditionalFileRepository;
import com.biz.crm.dms.business.contract.sdk.register.contract.ContractAdditionalFileRegister;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileInfoVo;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 合同附加类型文件vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Slf4j
@Service
public class ContractAdditionalFileVoServiceImpl implements ContractAdditionalFileVoService {

  @Autowired
  private ContractAdditionalFileRepository contractAdditionalFileRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<ContractAdditionalFileRegister> registers;

  @Override
  public List<ContractAdditionalFileVo> findByContractId(String contractId) {
    if (StringUtils.isBlank(contractId)) {
      return Lists.newLinkedList();
    }
    List<ContractAdditionalFile> additionalFiles = this.contractAdditionalFileRepository.findByContractId(contractId);
    if (CollectionUtils.isEmpty(additionalFiles)) {
      return Lists.newLinkedList();
    }
    Set<String> additionalFileCodes = additionalFiles.stream().map(ContractAdditionalFile::getAdditionalFileCode).collect(Collectors.toSet());
    Map<String, JSONObject> additionalMap = Maps.newHashMap();
    registers.forEach(register -> {
      Map<String, JSONObject> map = ObjectUtils.defaultIfNull(register.onRequestByAdditionalFileCodes(additionalFileCodes), Maps.newHashMap());
      map.forEach(additionalMap::put);
    });
    Map<String, ContractAdditionalFileVo> typeFileMap = Maps.newHashMap();
    additionalFiles.forEach(additionalFile -> {
      ContractAdditionalFileVo typeFileVo = typeFileMap.get(additionalFile.getFileType());
      if (Objects.isNull(typeFileVo)) {
        typeFileVo = new ContractAdditionalFileVo();
        typeFileVo.setContractId(additionalFile.getContractId());
        typeFileVo.setFileType(additionalFile.getFileType());
        typeFileVo.setFileList(Lists.newArrayList());
      }
      ContractAdditionalFileInfoVo fileVo = this.nebulaToolkitService.copyObjectByBlankList(additionalFile, ContractAdditionalFileInfoVo.class, HashSet.class, ArrayList.class);
      fileVo.setAdditionalJson(additionalMap.get(fileVo.getAdditionalTypeKey()));
      typeFileVo.getFileList().add(fileVo);
      typeFileMap.put(additionalFile.getFileType(), typeFileVo);
    });
    return Lists.newArrayList(typeFileMap.values());
  }
}
