package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.entity.contracthtml.ContractHtmlEntity;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.local.repository.contracthtml.ContractHtmlRepository;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileVoService;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @description: 合同vo
 * @author: rentao
 * @date: 2021/11/23 17:27
 */
@Slf4j
@Service
public class ContractVoServiceImpl implements ContractVoService {

  @Autowired(required = false)
  private ContractRepository contractRepository;
  @Autowired(required = false)
  private ContractHtmlRepository contractHtmlRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ContractElementService contractElementService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private ContractAdditionalFileVoService contractAdditionalFileVoService;

  /**
   *
   * 主键查询合同信息
   * @param id
   * @author rentao
   * @date
   */
  @Override
  public ContractVo findById(String id) {
    Validate.notEmpty(id,"传入主键为空！");
    Contract contract = this.contractRepository.getById(id);
    if (contract == null) { return null; }
    ContractVo vo = this.nebulaToolkitService.copyObjectByWhiteList(contract, ContractVo.class, HashSet.class, ArrayList.class);
    return this.assemblyDetails(vo);
  }

  /**
   *
   * 合同编码集合编码查询合同信息（没有明细信息）
   * @param contractCodes
   * @author rentao
   * @date
   */
  @Override
  public List<ContractVo> findByContractCodes(List<String> contractCodes) {
    List<Contract> list = this.contractRepository.findByContractCodes(contractCodes);
    if (CollectionUtils.isEmpty(list)) { return null; }
    return (List<ContractVo>)
        this.nebulaToolkitService.copyCollectionByWhiteList(
            list, Contract.class, ContractVo.class, HashSet.class, ArrayList.class);
  }

  /**
   *
   * 合同编码编码查询合同信息
   * @param code
   * @author rentao
   * @date
   */
  @Override
  public ContractVo findDetailsByCode(String code) {
    Validate.notEmpty(code,"传入合同编码为空！");
    Contract contract = this.contractRepository.findByContractCode(code);
    if (contract == null) { return null; }
    ContractVo vo = this.nebulaToolkitService.copyObjectByWhiteList(contract, ContractVo.class, HashSet.class, ArrayList.class);
    return this.assemblyDetails(vo);
  }

  /**
   *
   * 模板编码集合查询合同信息
   * @param templateCodes
   * @author rentao
   * @date
   */
  @Override
  public List<ContractVo> findByTemplateCode(List<String> templateCodes) {
    List<Contract> contracts = this.contractRepository.findByTemplateCode(templateCodes);
    if (CollectionUtils.isEmpty(contracts)) {
      return null;
    }
    List<ContractVo> contractVos =
        (List<ContractVo>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                contracts, Contract.class, ContractVo.class, HashSet.class, ArrayList.class);
    return contractVos;
  }

  /**
   * 客户-合同分页查询
   *
   * @param pageable
   * @param contractCustomerDto
   * @return
   */
  @Override
  public Page<ContractVo> findByContractCustomerDto(Pageable pageable,
      ContractCustomerDto contractCustomerDto) {
    String customerCode = contractCustomerDto.getCustomerCode();
    if (StringUtils.isBlank(customerCode)) {
      Page<ContractVo> pageResult = new Page<>(0L, 0L, 0L);
      return pageResult;
    }
    contractCustomerDto.setCusCode(customerCode);
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<Contract> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    contractCustomerDto = ObjectUtils.defaultIfNull(contractCustomerDto, new ContractCustomerDto());
    contractCustomerDto.setTenantCode(TenantUtils.getTenantCode());
    Page<Contract> entityResult = contractRepository
        .findByContractCustomerDto(page, contractCustomerDto);
    Page<ContractVo> pageResult = new Page<>(entityResult.getCurrent(), entityResult.getSize(),
        entityResult.getTotal());
    if (CollectionUtils.isEmpty(entityResult.getRecords())) {
      return pageResult;
    }
    //转换列表结果
    List<ContractVo> list = Lists.newArrayList(this.nebulaToolkitService
        .copyCollectionByBlankList(entityResult.getRecords(), Contract.class, ContractVo.class,
            HashSet.class, ArrayList.class));
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 客户-待签署合同数量
   *
   * @param contractCustomerDto
   * @return
   */
  @Override
  public Integer findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto) {
    String customerCode = contractCustomerDto.getCustomerCode();
    if (StringUtils.isBlank(customerCode)) {
      return 0;
    }
    contractCustomerDto.setCusCode(customerCode);
    contractCustomerDto.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getDictCode());
    return contractRepository.findUnsignedCountByCurrentCustomer(contractCustomerDto);
  }

  @Override
  public List<ContractVo> findEffectiveByCustomerCode(String customerCode) {
    if (StringUtils.isBlank(customerCode)) {
      return null;
    }
    String effectiveStatus = EffectiveStatusEnum.EFFECTIVE_ACTIVE.getDictCode();
    List<Contract> list = contractRepository.findByCustomerCodeAndEffectiveStatus(customerCode, effectiveStatus);
    List<ContractVo> voList = (List<ContractVo>) this.nebulaToolkitService
        .copyCollectionByBlankList(list, Contract.class, ContractVo.class, HashSet.class, ArrayList.class);
    return voList;
  }

  /**
   * 组装明细
   *
   * @param vo
   * @return
   */
  private ContractVo assemblyDetails(ContractVo vo) {
    Map<String, JSONObject> elementDataMap = new HashMap<>();
    elementDataMap.putAll(this.contractElementService.findContractElement(vo));
    elementDataMap.putAll(this.contractElementService.findInitiativeContractElement(vo));
    vo.setElementDataMap(elementDataMap);
    ContractHtmlEntity contractHtmlEntity = this.contractHtmlRepository
        .findByContractCode(vo.getContractCode());
    if (Objects.nonNull(contractHtmlEntity)) {
      vo.setHtmlStr(contractHtmlEntity.getHtmlStr());
    }
    vo.setAdditionalFileList(this.contractAdditionalFileVoService.findByContractId(vo.getId()));
    return vo;
  }
}
