package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractEventDto;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractManagementEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @description: 合同通知事件
 * @author: rentao
 * @date: 2022/5/25 11:42
 */
@Component
public class ContractManagementEventListenerImpl implements ContractManagementEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  /**
   * 创建事件
   */
  @Override
  public void onCreate(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.CREATE);
  }

  /**
   * 编辑事件
   */
  @Override
  public void onUpdate(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
  }

  /**
   * 删除事件
   */
  @Override
  public void onDelete(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.DELETE);
  }

  /**
   * 启用事件
   */
  @Override
  public void onEnable(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
  }

  /**
   * 禁用事件
   */
  @Override
  public void onDisable(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
  }

  /**
   * 禁用事件
   */
  @Override
  public void onCancellation(ContractEventDto contractEventDto) {
    this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
  }


  public void handleUpdate(ContractEventDto contractEventDto,
      OperationTypeEunm operationTypeEunm) {
    Object original = contractEventDto.getOriginal();
    Object newest = contractEventDto.getNewest();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
    crmBusinessLogDto.setOnlyKey(contractEventDto.getOnlyKey());
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }
}
