package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.dms.business.contract.local.constant.ContractConstant;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 弃用（现用：ProcessCompleteListenerOfContract）
 *
 * @description: 合同审批回调
 * @author: rentao
 * @date: 2022/3/30 0:24
 */
@Deprecated
@Component
public class ContractProcessCallBackListener implements CallBackListener {

  @Autowired(required = false)
  private ContractRepository contractRepository;

  /**
   *
   * 合同审批回调
   * @param dto
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(ContractConstant.CONTRACT_PROCESS_NAME)) {
      return;
    }
    //校验单号
    Contract contract = contractRepository.findByContractProcessNo(dto.getProcessNo());
    if (ObjectUtils.isEmpty(contract)) {
      return;
    }
    //校验合同审批状态
    Validate.isTrue(contract.getContractStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()), "此订单非审批中状态，无法进行操作！");
    //更改合同审批状态
    contract.setContractStatus(String.valueOf(dto.getProcessState()));
    if(ActApproveStatusEnum.APPROVED.getCode().equals(String.valueOf(dto.getProcessState()))){
      contract.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getKey());
    }
    //流程追回
    if(ActApproveStatusEnum.INTERRUPT.getCode().equals(String.valueOf(dto.getProcessState()))){
      contract.setContractStatus(ActApproveStatusEnum.CREATE.getCode());
      contract.setProcessNumber(null);
      contract.setProcessRemark(null);
    }
    contractRepository.updateById(contract);
  }
}
