package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.dms.business.contract.local.utils.contract.ContractUtil;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.strategy.ContractSignStrategy;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import org.springframework.stereotype.Component;

/**
 * @description: 线上签署
 * @author: rentao
 * @date: 2022/6/7 14:28
 */
@Component
public class ContractSignOnlineStrategy implements ContractSignStrategy {

  /**
   * 查询签约类型名称
   */
  @Override
  public String getContractSignTypeName() {
    return ContractSignType.ONLINE_SIGNATURE.name();
  }

  /**
   * 查询签约类型名称
   */
  @Override
  public String getContractSignTypeCode() {
    return ContractSignType.ONLINE_SIGNATURE.getKey();

  }

  /**
   * 签约方法
   */
  @Override
  public void onRequestContractSign(ContractVo vo) {
    ContractUtil.validateSignContract(vo);
    vo.setContractStatus(ActApproveStatusExtendEnum.SIGN_CONTRACT.getKey());
  }
}
