package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.dms.business.contract.local.constant.ContractConstant;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 合同审批回调
 *
 * @author rentao, hefan
 * @date 2022/08/31
 */
@Component
public class ProcessCompleteListenerOfContract implements ProcessCompleteListener {
  @Autowired(required = false)
  private ContractRepository contractRepository;

  @Override
  public String getBusinessCode() {
    return ContractConstant.CONTRACT_PROCESS_NAME;
  }

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!ContractConstant.CONTRACT_PROCESS_NAME.equals(dto.getBusinessCode())) {
      return;
    }
    //校验单号
    Contract contract = contractRepository.findByContractProcessNo(dto.getProcessNo());
    if (ObjectUtils.isEmpty(contract)) {
      return;
    }
    //校验合同审批状态
    Validate.isTrue(contract.getContractStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()), "此订单非审批中状态，无法进行操作！");
    //更改合同审批状态
    contract.setContractStatus(dto.getProcessStatus());
    if(ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())){
      contract.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getKey());
    }
    //流程追回
    if(ProcessStatusEnum.RECOVER.getDictCode().equals(dto.getProcessStatus())){
      contract.setContractStatus(ProcessStatusEnum.PREPARE.getDictCode());
      contract.setProcessNumber(null);
      contract.setProcessRemark(null);
    }
    contractRepository.updateById(contract);
  }
}
