package com.biz.crm.dms.business.contract.local.service.contractaddresscontact;

import com.biz.crm.dms.business.contract.local.entity.contractaddresscontact.ContractAddressContact;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAddressContactDataVo;

/**
 * 合同地址联系人表服务接口
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:06
 */
public interface ContractAddressContactService {

  /**
   * 合同编码查询
   *
   * @param contractCode 合同编码
   * @return 要素信息
   */
  ContractAddressContact findByContractCode(String contractCode);

  /**
   * 要素内容保存
   *
   * @param contractCode 合同编码
   * @param vo           要素数据VO
   * @param indexCode    顺序编码
   * @return 要素信息
   */
  ContractAddressContact create(String contractCode, ContractAddressContactDataVo vo, Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode 合同编码
   * @param vo           要素数据VO
   * @param indexCode    顺序编码
   * @return 要素信息
   */
  ContractAddressContact update(String contractCode, ContractAddressContactDataVo vo, Integer indexCode);
}
