package com.biz.crm.dms.business.contract.local.service.contractaddresscontact.internal;

import com.biz.crm.dms.business.contract.local.entity.contractaddresscontact.ContractAddressContact;
import com.biz.crm.dms.business.contract.local.repository.contractaddresscontact.ContractAddressContactRepository;
import com.biz.crm.dms.business.contract.local.service.contractaddresscontact.ContractAddressContactService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAddressContactDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 合同地址联系人表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:06
 */
@Slf4j
@Service("contractAddressContactService")
public class ContractAddressContactServiceImpl implements ContractAddressContactService {

  @Autowired
  private ContractAddressContactRepository contractAddressContactRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public ContractAddressContact findByContractCode(String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return null;
    }
    return this.contractAddressContactRepository.findByContractCode(contractCode);
  }

  @Override
  public ContractAddressContact create(String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
    this.validateCreateOrUpdate(contractCode, vo);
    ContractAddressContact addressContact = this.nebulaToolkitService.copyObjectByWhiteList(vo, ContractAddressContact.class, HashSet.class, ArrayList.class);
    addressContact.setContractCode(contractCode);
    this.contractAddressContactRepository.save(addressContact);
    return addressContact;
  }

  @Override
  public ContractAddressContact update(String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
    this.validateCreateOrUpdate(contractCode, vo);
    this.contractAddressContactRepository.deleteByContractCode(contractCode);
    ContractAddressContact addressContact = this.nebulaToolkitService.copyObjectByWhiteList(vo, ContractAddressContact.class, HashSet.class, ArrayList.class);
    addressContact.setContractCode(contractCode);
    this.contractAddressContactRepository.save(addressContact);
    return addressContact;
  }

  /**
   * 更新和保存参数校验
   *
   * @param contractCode 合同编码
   * @param vo           要素数据Vo
   */
  private void validateCreateOrUpdate(String contractCode, ContractAddressContactDataVo vo) {
    // 校验入参
    Validate.notBlank(contractCode, "合同编码不能为空");
    Validate.notNull(vo, "合同地址联系人内容为空");
    Validate.notBlank(vo.getSupplierLegalAddress(), "供方法定地址为空");
    Validate.notBlank(vo.getSupplierContact(), "供方联系人为空");
    Validate.notBlank(vo.getBuyerLegalAddress(), "需方法定地址为空");
    Validate.notBlank(vo.getBuyerContact(), "需方联系人为空");
  }
}
