package com.biz.crm.dms.business.contract.local.service.contractaddresscontact.register;

import com.biz.crm.dms.business.contract.local.entity.contractaddresscontact.ContractAddressContact;
import com.biz.crm.dms.business.contract.local.service.contractaddresscontact.ContractAddressContactService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAddressContactDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 合同地址联系人要素注册
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
//@Service("contractAddressContactElementRegister")
public class ContractAddressContactElementRegister implements ContractElementRegister<ContractAddressContactDataVo> {

  @Autowired(required = false)
  private ContractAddressContactService contractAddressContactService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 合同要素编码
   */
  private static final String CONTRACT_ELEMENT_CODE = "contractAddressContactElementRegister";

  /**
   * 合同要素组件名称
   */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-addresscontract";

  /**
   * 合同要素名称
   */
  private static final String CONTRACT_ELEMENT_NAME = "合同地址联系人";

  /**
   * 合同要素排序
   */
  private static final Integer ELEMENT_SORT = 10;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<ContractAddressContactDataVo> getContractElementClass() {
    return ContractAddressContactDataVo.class;
  }

  @Override
  public ContractAddressContactDataVo getByContractCode(String contractCode) {
    ContractAddressContact addressContact = this.contractAddressContactService.findByContractCode(contractCode);
    if (Objects.isNull(addressContact)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(addressContact, ContractAddressContactDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public ContractAddressContactDataVo onRequestContractCreate(
      String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
    ContractAddressContact addressContact = this.contractAddressContactService.create(contractCode, vo, indexCode);
    if (Objects.isNull(addressContact)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(addressContact, ContractAddressContactDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public ContractAddressContactDataVo onRequestContractUpdate(
      String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
    ContractAddressContact addressContact = this.contractAddressContactService.update(contractCode, vo, indexCode);
    if (Objects.isNull(addressContact)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(addressContact, ContractAddressContactDataVo.class, HashSet.class, ArrayList.class);
  }
}
