package com.biz.crm.dms.business.contract.local.service.contractarea.register;

import com.biz.crm.dms.business.contract.local.service.contractarea.ContractAreaDataVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAreaDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 合同销售区域要素注册
 * @author: rentao
 * @date: 2021/12/17 16:12
 */
@Service("contractAreaElementRegister")
public class ContractAreaElementRegister implements ContractElementRegister<ContractAreaDataVo> {

  @Autowired(required = false) private ContractAreaDataVoService contractAreaDataVoService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "contractAreaElementRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-salearea";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "合同销售区域";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 2;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<ContractAreaDataVo> getContractElementClass() {
    return ContractAreaDataVo.class;
  }

  @Override
  public ContractAreaDataVo getByContractCode(String contractcode) {
    return this.contractAreaDataVoService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public ContractAreaDataVo onRequestContractCreate(
      String contractCode, ContractAreaDataVo contractAreaElementDataVo, Integer indexCode) {
    return this.contractAreaDataVoService.createContractDetailsElement(
        contractCode, contractAreaElementDataVo, indexCode);
  }

  @Override
  @Transactional
  public ContractAreaDataVo onRequestContractUpdate(
      String contractCode, ContractAreaDataVo contractAreaElementDataVo, Integer indexCode) {
    return this.contractAreaDataVoService.updateContractDetailsElement(
        contractCode, contractAreaElementDataVo, indexCode);
  }
}
