package com.biz.crm.dms.business.contract.local.service.contractdetailselement;

import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractDetailsElementDataVo;

/**
 * @description: 合同细则 要素
 * @author: rentao
 * @date: 2021/11/22 15:42
 */
public interface ContractDetailsElementDataVoService {

  /**
   * 查询要素内容
   *
   * @param contractcode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  ContractDetailsElementDataVo findByContractCode(String contractcode);

  /**
   * 要素内容保存
   *
   * @param contractCode
   * @param contractDetailsElementDataVo
   * @param indexCode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  ContractDetailsElementDataVo createContractDetailsElement(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode
   * @param contractDetailsElementDataVo
   * @param indexCode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  ContractDetailsElementDataVo updateContractDetailsElement(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode);
}
