package com.biz.crm.dms.business.contract.local.service.contractdetailselement.internal;

import com.biz.crm.dms.business.contract.local.entity.contractdetailselement.ContractDetailsElement;
import com.biz.crm.dms.business.contract.local.repository.contractdetailselement.ContractDetailsElementRepository;
import com.biz.crm.dms.business.contract.local.service.contractdetailselement.ContractDetailsElementDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractDetailsElementDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @description: 合同要素细则
 * @author: rentao
 * @date: 2021/11/22 15:42
 */
@Slf4j
@Service
public class ContractDetailsElementDataVoServiceImpl implements ContractDetailsElementDataVoService {

  @Autowired(required = false) private ContractDetailsElementRepository contractDetailsElementRepository;

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  /**
   * 查询要素内容
   *
   * @param contractcode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  @Override
  public ContractDetailsElementDataVo findByContractCode(String contractcode) {
    ContractDetailsElement contractDetailsElement =
        this.contractDetailsElementRepository.findByContractCode(contractcode);
    if (Objects.isNull(contractDetailsElement)) {
      return null;
    }
    ContractDetailsElementDataVo vo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractDetailsElement,
            ContractDetailsElementDataVo.class,
            HashSet.class,
            ArrayList.class);
    return vo;
  }

  /**
   * 要素内容保存
   *
   * @param contractCode
   * @param contractDetailsElementDataVo
   * @param indexCode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  @Override
  @Transactional
  public ContractDetailsElementDataVo createContractDetailsElement(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode) {
    // 校验入参
    this.validateSaveOrUpdate(contractCode, contractDetailsElementDataVo);
    ContractDetailsElement contractDetailsElement =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractDetailsElementDataVo,
            ContractDetailsElement.class,
            HashSet.class,
            ArrayList.class);
    contractDetailsElement.setContractCode(contractCode);
    this.contractDetailsElementRepository.save(contractDetailsElement);
    return contractDetailsElementDataVo;
  }

  /**
   * 要素内容修改
   *
   * @param contractCode
   * @param contractDetailsElementDataVo
   * @param indexCode
   * @author rentao
   * @date ContractDetailsElementDataVo
   */
  @Override
  @Transactional
  public ContractDetailsElementDataVo updateContractDetailsElement(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode) {
    // 校验入参
    this.validateSaveOrUpdate(contractCode, contractDetailsElementDataVo);
    ContractDetailsElement contractDetailsElement =
        this.contractDetailsElementRepository.findByContractCode(contractCode);
    Validate.notNull(contractDetailsElement, "合同违约责任不存在");
    ContractDetailsElement detailsElement =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractDetailsElementDataVo,
            ContractDetailsElement.class,
            HashSet.class,
            ArrayList.class);
    detailsElement.setContractCode(contractCode);
    detailsElement.setId(contractDetailsElement.getId());
    this.contractDetailsElementRepository.updateById(detailsElement);
    return contractDetailsElementDataVo;
  }

  /**
   * 入参校验
   *
   * @param contractCode
   * @param contractDetailsElementDataVo
   * @author rentao
   * @date
   */
  private void validateSaveOrUpdate(
      String contractCode, ContractDetailsElementDataVo contractDetailsElementDataVo) {
    // 校验入参
    Validate.notBlank(contractCode, "合同编码不能为空");
    Validate.notNull(contractDetailsElementDataVo, "合同细则为空");
    Validate.notBlank(contractDetailsElementDataVo.getContractDetails(), "合同细则为空为空");
    Validate.isTrue(
        contractDetailsElementDataVo.getContractDetails().length() <= 20000, "合同细则长度不能超过20000");
  }
}
