package com.biz.crm.dms.business.contract.local.service.contractdetailselement.register;

import com.biz.crm.dms.business.contract.local.service.contractdetailselement.ContractDetailsElementDataVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractDetailsElementDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 合同细则要素注册
 * @author: rentao
 * @date: 2021/11/22 15:43
 */
@Service("contractDetailsElementRegister")
public class ContractDetailsElementRegister
    implements ContractElementRegister<ContractDetailsElementDataVo> {

  @Autowired(required = false) private ContractDetailsElementDataVoService contractDetailsElementDataVoService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "contractDetailsElementRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME =
      "dms-contract-manage-contractdetails";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "合同细则";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 6;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class getContractElementClass() {
    return ContractDetailsElementDataVo.class;
  }

  @Override
  public ContractDetailsElementDataVo getByContractCode(String contractcode) {
    return this.contractDetailsElementDataVoService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public ContractDetailsElementDataVo onRequestContractCreate(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode) {
    return this.contractDetailsElementDataVoService.createContractDetailsElement(
        contractCode, contractDetailsElementDataVo, indexCode);
  }

  @Override
  @Transactional
  public ContractDetailsElementDataVo onRequestContractUpdate(
      String contractCode,
      ContractDetailsElementDataVo contractDetailsElementDataVo,
      Integer indexCode) {
    return this.contractDetailsElementDataVoService.updateContractDetailsElement(
        contractCode, contractDetailsElementDataVo, indexCode);
  }
}
