package com.biz.crm.dms.business.contract.local.service.contractelement.internal;

import com.biz.crm.dms.business.contract.local.context.contractelement.ContractElementContext;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementModelVoService;
import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelement.ContractElementModelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 合同要素
 * @author: rentao
 * @date: 2021/11/15 18:42
 */
@Service
public class ContractElementModelVoServiceImpl implements ContractElementModelVoService {

  @Autowired(required = false) private ContractElementContext contractElementContext;

  /**
   * 条件查询合同要素
   *
   * @param contractSignType
   */
  @Override
  public List<ContractElementModelVo> findByConditions(String contractSignType) {
    List<ContractElementModelVo> allConfig = this.contractElementContext.getAllConfig(contractSignType);
    return allConfig;
  }
}
