package com.biz.crm.dms.business.contract.local.service.contractelement.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementService;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractElementDataVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description: 合同要素service
 * @author: rentao
 * @date: 2022/6/7 11:01
 */
@Slf4j
@Service
public class ContractElementServiceImpl implements ContractElementService {

  @Autowired(required = false)
  private ContractTemplateVoService contractTemplateVoService;

  @Autowired(required = false)
  private List<ContractElementRegister> elementRegisters;

  /**
   * 查询合同要素内容(主动调用)
   * @return
   */
  @Override
  public Map<String, JSONObject> findInitiativeContractElement(ContractVo contractVo) {
    Validate.notNull(contractVo,"传入数据为空");
    Validate.notNull(contractVo.getTemplateCode(),"传入合同模板编码为空");
    // 获取到模板vo
    ContractTemplateVo templateVo = this.contractTemplateVoService.findDetailsByCode(contractVo.getTemplateCode());
    Validate.notNull(templateVo, "没有获取到原始模板");
    // 拼接合同要素内容数据
    Map<String, JSONObject> elementDataMap = new HashMap<>();
    List<ContractTemplateElementVo> elementModelVos = templateVo.getTemplateElements();
    if (CollectionUtils.isNotEmpty(elementModelVos) && CollectionUtils.isNotEmpty(elementRegisters)) {
      for (ContractTemplateElementVo templateElementVo : elementModelVos) {
        List<ContractElementRegister> contractElementRegisters =
            elementRegisters.stream()
                .filter(
                    elementRegister ->
                        elementRegister
                            .getContractElementCode()
                            .equals(templateElementVo.getElementCode()))
                .collect(Collectors.toList());
        Validate.isTrue(CollectionUtils.isNotEmpty(contractElementRegisters), "要素不存在");
        ContractElementRegister contractElementRegister = contractElementRegisters.get(0);
        ContractElementDataVo contractElementDateVo =
            contractElementRegister.onRequestContractElement(contractVo);
        if(Objects.nonNull(contractElementDateVo)){
          elementDataMap.put(templateElementVo.getElementCode(), JsonUtils.toJSONObject(contractElementDateVo));
        }
      }
    }
    return elementDataMap;
  }

  /**
   * 查询合同要素内容(合同正常调用)
   * @return
   */
  @Override
  public Map<String, JSONObject> findContractElement(ContractVo contractVo) {
    // 获取到模板vo
    ContractTemplateVo templateVo =
        this.contractTemplateVoService.findDetailsByCode(contractVo.getTemplateCode());
    Validate.notNull(templateVo, "没有获取到原始模板");
    // 拼接合同要素内容数据
    Map<String, JSONObject> elementDataMap = new HashMap<>();
    List<ContractTemplateElementVo> elementModelVos = templateVo.getTemplateElements();
    if (CollectionUtils.isNotEmpty(elementModelVos)
        && CollectionUtils.isNotEmpty(elementRegisters)) {
      for (ContractTemplateElementVo templateElementVo : elementModelVos) {
        List<ContractElementRegister> contractElementRegisters =
            elementRegisters.stream()
                .filter(
                    elementRegister ->
                        elementRegister
                            .getContractElementCode()
                            .equals(templateElementVo.getElementCode()))
                .collect(Collectors.toList());
        Validate.isTrue(CollectionUtils.isNotEmpty(contractElementRegisters), "要素不存在");
        ContractElementRegister contractElementRegister = contractElementRegisters.get(0);
        ContractElementDataVo contractElementDateVo =
            contractElementRegister.getByContractCode(contractVo.getContractCode());
        elementDataMap.put(
            templateElementVo.getElementCode(), JsonUtils.toJSONObject(contractElementDateVo));
      }
    }
    return elementDataMap;
  }
}
