package com.biz.crm.dms.business.contract.local.service.contractfiles;

import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFilesDataVo;

/**
 * @description: 合同附件
 * @author: rentao
 * @date: 2021/11/22 13:22
 */
public interface ContractFilesDataVoService {

  /**
   * 查询要素内容
   *
   * @param contractCode 合同编码
   * @author rentao
   * @date
   */
  ContractFilesDataVo findByContractCode(String contractCode);

  /**
   * 新增合同要素
   *
   * @param contractCode 合同编码
   * @param contractFilesDateVo 文件要素
   * @param indexCode 文件要素在合同中的顺序
   * @author rentao
   * @date
   */
  ContractFilesDataVo createContractFilesElement(
      String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode);

  /**
   * 编辑合同要素
   *
   * @param contractCode 合同编码
   * @param contractFilesDateVo 文件要素
   * @param indexCode 文件要素在合同中的顺序
   * @author rentao
   * @date
   */
  ContractFilesDataVo updateContractFilesElement(
      String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode);
}
