package com.biz.crm.dms.business.contract.local.service.contractfiles.register;

import com.biz.crm.dms.business.contract.local.service.contractfiles.ContractFilesDataVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFilesDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 合同附件(实现)
 * @author: rentao
 * @date: 2021/11/19 11:00
 */
@Service("contractFilesRegister")
public class ContractFilesRegister implements ContractElementRegister<ContractFilesDataVo> {

  @Autowired(required = false) private ContractFilesDataVoService contractFilesDataVoService;

  /** 合同要素编码 */
  private static final String CONTRACT_ELEMENT_CODE = "contractFilesRegister";

  /** 合同要素组件名称 */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-contractfiles";

  /** 合同要素名称 */
  private static final String CONTRACT_ELEMENT_NAME = "合同附件";

  /** 合同要素排序 */
  private static final Integer ELEMENT_SORT = 9;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<ContractFilesDataVo> getContractElementClass() {
    return ContractFilesDataVo.class;
  }

  @Override
  public ContractFilesDataVo getByContractCode(String contractcode) {
    return this.contractFilesDataVoService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public ContractFilesDataVo onRequestContractCreate(
      String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode) {
    return this.contractFilesDataVoService.createContractFilesElement(
        contractCode, contractFilesDateVo, indexCode);
  }

  @Override
  @Transactional
  public ContractFilesDataVo onRequestContractUpdate(
      String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode) {
    return this.contractFilesDataVoService.updateContractFilesElement(
        contractCode, contractFilesDateVo, indexCode);
  }
}
