package com.biz.crm.dms.business.contract.local.service.contractfreight;

import com.biz.crm.dms.business.contract.local.entity.contractfreight.ContractFreight;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFreightDataVo;

/**
 * 合同运费表服务接口
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:05
 */
public interface ContractFreightService {

  /**
   * 合同编码查询
   *
   * @param contractCode 合同编码
   * @return 要素信息
   */
  ContractFreight findByContractCode(String contractCode);

  /**
   * 要素内容保存
   *
   * @param contractCode 合同编码
   * @param vo           要素数据VO
   * @param indexCode    顺序编码
   * @return 要素信息
   */
  ContractFreight create(String contractCode, ContractFreightDataVo vo, Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode 合同编码
   * @param vo           要素数据VO
   * @param indexCode    顺序编码
   * @return 要素信息
   */
  ContractFreight update(String contractCode, ContractFreightDataVo vo, Integer indexCode);
}
