package com.biz.crm.dms.business.contract.local.service.contractfreight.internal;

import com.biz.crm.dms.business.contract.local.entity.contractfreight.ContractFreight;
import com.biz.crm.dms.business.contract.local.repository.contractfreight.ContractFreightRepository;
import com.biz.crm.dms.business.contract.local.service.contractfreight.ContractFreightService;
import com.biz.crm.dms.business.contract.sdk.enums.DistributionEnum;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFreightDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 合同运费表服务实现类
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:05
 */
@Slf4j
@Service("contractFreightService")
public class ContractFreightServiceImpl implements ContractFreightService {

  @Autowired
  private ContractFreightRepository contractFreightRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public ContractFreight findByContractCode(String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return null;
    }
    return this.contractFreightRepository.findByContractCode(contractCode);
  }

  @Override
  public ContractFreight create(String contractCode, ContractFreightDataVo vo, Integer indexCode) {
    this.validateCreateOrUpdate(contractCode, vo);
    ContractFreight addressContact = this.nebulaToolkitService.copyObjectByWhiteList(vo, ContractFreight.class, HashSet.class, ArrayList.class);
    addressContact.setContractCode(contractCode);
    this.contractFreightRepository.save(addressContact);
    return addressContact;
  }

  @Override
  public ContractFreight update(String contractCode, ContractFreightDataVo vo, Integer indexCode) {
    this.validateCreateOrUpdate(contractCode, vo);
    this.contractFreightRepository.deleteByContractCode(contractCode);
    ContractFreight addressContact = this.nebulaToolkitService.copyObjectByWhiteList(vo, ContractFreight.class, HashSet.class, ArrayList.class);
    addressContact.setContractCode(contractCode);
    this.contractFreightRepository.updateById(addressContact);
    return addressContact;
  }

  /**
   * 更新和保存参数校验
   *
   * @param contractCode 合同编码
   * @param vo           要素数据Vo
   */
  private void validateCreateOrUpdate(String contractCode, ContractFreightDataVo vo) {
    Validate.notBlank(contractCode, "合同编码不能为空");
    Validate.notNull(vo, "合同运费内容为空");
    Validate.notBlank(vo.getDistributionType(), "配送方式为空");
    if (DistributionEnum.DELIVERY.getDictCode().equals(vo.getDistributionType())) {
      Validate.notBlank(vo.getSettlementType(), "结算方式为空");
      Validate.isTrue(Objects.nonNull(vo.getFreightAmount()) && vo.getFreightAmount().compareTo(BigDecimal.ZERO) >= 0, "运费金额错误");
    }

  }
}
