package com.biz.crm.dms.business.contract.local.service.contractfreight.register;

import com.biz.crm.dms.business.contract.local.entity.contractfreight.ContractFreight;
import com.biz.crm.dms.business.contract.local.service.contractfreight.ContractFreightService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFreightDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 合同运费要素注册
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
//@Service("contractFreightElementRegister")
public class ContractFreightElementRegister implements ContractElementRegister<ContractFreightDataVo> {

  @Autowired(required = false)
  private ContractFreightService contractFreightService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 合同要素编码
   */
  private static final String CONTRACT_ELEMENT_CODE = "contractFreightElementRegister";

  /**
   * 合同要素组件名称
   */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-freight";

  /**
   * 合同要素名称
   */
  private static final String CONTRACT_ELEMENT_NAME = "合同运费";

  /**
   * 合同要素排序
   */
  private static final Integer ELEMENT_SORT = 11;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<ContractFreightDataVo> getContractElementClass() {
    return ContractFreightDataVo.class;
  }

  @Override
  public ContractFreightDataVo getByContractCode(String contractCode) {
    ContractFreight contractFreight = this.contractFreightService.findByContractCode(contractCode);
    if (Objects.isNull(contractFreight)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(contractFreight, ContractFreightDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public ContractFreightDataVo onRequestContractCreate(
      String contractCode, ContractFreightDataVo vo, Integer indexCode) {
    ContractFreight contractFreight = this.contractFreightService.create(contractCode, vo, indexCode);
    if (Objects.isNull(contractFreight)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(contractFreight, ContractFreightDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public ContractFreightDataVo onRequestContractUpdate(
      String contractCode, ContractFreightDataVo vo, Integer indexCode) {
    ContractFreight contractFreight = this.contractFreightService.update(contractCode, vo, indexCode);
    if (Objects.isNull(contractFreight)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByBlankList(contractFreight, ContractFreightDataVo.class, HashSet.class, ArrayList.class);
  }
}
