package com.biz.crm.dms.business.contract.local.service.contractliability;

import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractLiabilityDataVo;

/**
 * @description: 合同要素 违约责任
 * @author: rentao
 * @date: 2021/11/22 16:21
 */
public interface ContractLiabilityDataVoService {

  /**
   * 查询要素内容
   *
   * @param contractcode 合同编码
   * @author rentao
   * @date
   */
  ContractLiabilityDataVo findByContractCode(String contractcode);

  /**
   * 新增合同要素
   *
   * @param contractCode            合同编码
   * @param contractLiabilityDataVo 违约责任要素
   * @param indexCode               违约责任要素在合同中的顺序
   * @author rentao
   * @date
   */
  ContractLiabilityDataVo createContractLiability(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode);

  /**
   * 编辑合同要素
   *
   * @param contractCode            合同编码
   * @param contractLiabilityDataVo 违约责任要素
   * @param indexCode               违约责任要素在合同中的顺序
   * @author rentao
   * @date
   */
  ContractLiabilityDataVo updateContractLiability(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode);

}
