package com.biz.crm.dms.business.contract.local.service.contractliability.register;

import com.biz.crm.dms.business.contract.local.service.contractliability.ContractLiabilityDataVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractLiabilityDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 合同要素 违约责任注册
 * @author: rentao
 * @date: 2021/11/22 16:22
 */
@Service("contractLiabilityRegister")
public class ContractLiabilityRegister implements ContractElementRegister<ContractLiabilityDataVo> {

  @Autowired(required = false)
  private ContractLiabilityDataVoService contractLiabilityDataVoService;

  /**
   * 合同要素编码
   */
  private static final String CONTRACT_ELEMENT_CODE = "contractLiabilityRegister";

  /**
   * 合同要素组件名称
   */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-contractbreach";

  /**
   * 合同要素名称
   */
  private static final String CONTRACT_ELEMENT_NAME = "违约责任";

  /**
   * 合同要素排序
   */
  private static final Integer ELEMENT_SORT = 7;

  /**
   * 查询合同要素名称
   */
  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  /**
   * 查询合同要素编码
   */
  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  /**
   * 查询合同组件名称
   * */
  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  /**
   * 拿到要素排序列表排序
   */
  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  /**
   * 查询要素bean
   */
  @Override
  public Class getContractElementClass() {
    return ContractLiabilityDataVo.class;
  }

  /**
   * 合同编码查询查询合同要素内容
   *
   * @param contractcode
   */
  @Override
  public ContractLiabilityDataVo getByContractCode(String contractcode) {
    return this.contractLiabilityDataVoService.findByContractCode(contractcode);
  }

  /**
   * 保存对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public ContractLiabilityDataVo onRequestContractCreate(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode) {
    return this.contractLiabilityDataVoService.createContractLiability(contractCode, contractLiabilityDataVo, indexCode);
  }

  /**
   * 编辑对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public ContractLiabilityDataVo onRequestContractUpdate(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode) {
    return this.contractLiabilityDataVoService.updateContractLiability(contractCode, contractLiabilityDataVo, indexCode);
  }

}
