package com.biz.crm.dms.business.contract.local.service.contractsignbar.internal;

import com.biz.crm.dms.business.contract.local.entity.contractsignbar.ContractSignBar;
import com.biz.crm.dms.business.contract.local.repository.contractsignbar.ContractSignBarRepository;
import com.biz.crm.dms.business.contract.local.service.contractsignbar.ContractSignBarDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractSignBarDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @description: 合同签署栏
 * @author: rentao
 * @date: 2021/11/24 10:04
 */
@Slf4j
@Service
public class ContractSignBarDataVoServiceImpl implements ContractSignBarDataVoService {

  @Autowired(required = false) private ContractSignBarRepository contractSignBarRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 查询要素内容
   */
  @Override
  public ContractSignBarDataVo findByContractCode(String contractcode) {
    ContractSignBar contractSignBar =
        this.contractSignBarRepository.findByContractCode(contractcode);
    if (Objects.isNull(contractSignBar)) {
      return null;
    }
    ContractSignBarDataVo vo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractSignBar, ContractSignBarDataVo.class, HashSet.class, ArrayList.class);
    return vo;
  }

  /**
   * 要素内容保存
   */
  @Override
  @Transactional
  public ContractSignBarDataVo createContractSignBar(
      String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
    // 校验入参
    this.validateSaveOrUpdate(contractCode, contractSignBarDataVo);
    ContractSignBar contractSignBar =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractSignBarDataVo, ContractSignBar.class, HashSet.class, ArrayList.class);
    contractSignBar.setContractCode(contractCode);
    this.contractSignBarRepository.save(contractSignBar);
    return contractSignBarDataVo;
  }

  /**
   * 要素内容修改
   * */
  @Override
  @Transactional
  public ContractSignBarDataVo updateContractSignBar(
      String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
    // 校验入参
    this.validateSaveOrUpdate(contractCode, contractSignBarDataVo);
    ContractSignBar signBar = this.contractSignBarRepository.findByContractCode(contractCode);
    Validate.notNull(signBar, "合同签署栏不存在");
    ContractSignBar contractSignBar =
        this.nebulaToolkitService.copyObjectByWhiteList(
            contractSignBarDataVo, ContractSignBar.class, HashSet.class, ArrayList.class);
    contractSignBar.setContractCode(contractCode);
    contractSignBar.setId(signBar.getId());
    this.contractSignBarRepository.updateById(contractSignBar);
    return contractSignBarDataVo;
  }

  private void validateSaveOrUpdate(
      String contractCode, ContractSignBarDataVo contractSignBarDataVo) {
    // 校验入参
    Validate.notBlank(contractCode, "合同编码不能为空");
    Validate.notNull(contractSignBarDataVo, "合同签署栏内容为空");
    Validate.notBlank(contractSignBarDataVo.getFirstPartyName(), "合同甲方名称为空");
    Validate.isTrue(contractSignBarDataVo.getFirstPartyName().length() <= 30, "合同甲方名称不能超过30字符");
    Validate.notBlank(contractSignBarDataVo.getFirstPartySignDate(), "合同甲方签署日期为空");
    Validate.notBlank(contractSignBarDataVo.getSecondPartyName(), "合同乙方名称为空");
    Validate.isTrue(contractSignBarDataVo.getSecondPartyName().length() <= 30, "合同乙方名称不能超过30字符");
    Validate.notBlank(contractSignBarDataVo.getSecondPartySignDate(), "合同乙方签署日期为空");
  }
}
