package com.biz.crm.dms.business.contract.local.service.contractsignbar.register;

import com.biz.crm.dms.business.contract.local.service.contractsignbar.ContractSignBarDataVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractSignBarDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 合同签署栏
 * @author: rentao
 * @date: 2021/11/24 10:09
 */
@Service("contractSignBarRegister")
public class ContractSignBarRegister implements ContractElementRegister<ContractSignBarDataVo> {

  @Autowired(required = false)
  private ContractSignBarDataVoService contractSignBarDataVoService;

  /**
   * 合同要素组件名称
   */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-signbox";

  /**
   * 合同要素编码
   */
  private static final String CONTRACT_ELEMENT_CODE = "contractSignBarRegister";

  /**
   * 合同要素名称
   */
  private static final String CONTRACT_ELEMENT_NAME = "合同签署栏";

  /**
   * 合同要素排序
   */
  private static final Integer ELEMENT_SORT = 8;

  /**
   * 查询合同要素名称
   */
  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  /**
   * 查询合同要素编码
   */
  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  /**
   * 查询合同组件名称
   * */
  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  /**
   * 拿到要素排序列表排序
   */
  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  /**
   * 查询要素bean
   */
  @Override
  public Class<ContractSignBarDataVo> getContractElementClass() {
    return ContractSignBarDataVo.class;
  }

  /**
   * 合同编码查询查询合同要素内容
   *
   * @param contractcode
   */
  @Override
  public ContractSignBarDataVo getByContractCode(String contractcode) {
    return this.contractSignBarDataVoService.findByContractCode(contractcode);
  }

  /**
   * 保存对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public ContractSignBarDataVo onRequestContractCreate(String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
    return this.contractSignBarDataVoService.createContractSignBar(contractCode, contractSignBarDataVo, indexCode);
  }

  /**
   * 编辑对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public ContractSignBarDataVo onRequestContractUpdate(String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
    return this.contractSignBarDataVoService.updateContractSignBar(contractCode, contractSignBarDataVo, indexCode);
  }


}
