package com.biz.crm.dms.business.contract.local.service.contracttemplate;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * @description: 合同模板service
 * @author: rentao
 * @date: 2021/11/16 11:29
 */
public interface ContractTemplateService {

  /**
   * 新增合同模板
   *
   * @param dto
   * @return
   */
  ContractTemplate create(ContractTemplateDto dto);

  /**
   * 编辑合同模板
   *
   * @param dto
   * @return
   */
  ContractTemplate update(ContractTemplateDto dto);

  /**
   * 分页条件查询合同模板
   *
   * @param pageable 分页参数
   * @param dto 客户物料查询参数
   * @return 客户物料实体
   */
  Page<ContractTemplate> findByConditions(Pageable pageable, ContractTemplateDto dto);

  /**
   * 批量启用模板
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用模板
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 合同模板编码批量查询合同模板
   *
   * @param templateCodes
   * @author rentao
   * @date a
   */
  List<ContractTemplate> findByTemplateCodes(Set<String> templateCodes);

  /**
   * 删除模板
   * @param ids
   */
  void deleteBatch(List<String> ids);
}
