package com.biz.crm.dms.business.contract.local.service.contracttemplate.internal;

import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.repository.contracttemplate.ContractTemplateRepository;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.local.service.contracttemplateelement.ContractTemplateElementVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @description: 合同模板 vo service
 * @author: rentao
 * @date: 2021/11/23 17:44
 */
@Slf4j
@Service
public class ContractTemplateVoServiceImpl implements ContractTemplateVoService {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private ContractTemplateElementVoService contractTemplateElementVoService;

  @Autowired(required = false)
  private ContractTemplateRepository contractTemplateRepository;

  /**
   * 根据id查询合同模板
   *
   * @param id
   * @return
   */
  @Override
  public ContractTemplateVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ContractTemplate entity = this.contractTemplateRepository.getById(id);
    if (entity == null) {
      return null;
    }
    ContractTemplateVo templateVo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            entity, ContractTemplateVo.class, HashSet.class, ArrayList.class);
    List<ContractTemplateElementVo> templateElementList =
        this.contractTemplateElementVoService.findByContractTemplateCode(
            templateVo.getTemplateCode());
    if (CollectionUtils.isNotEmpty(templateElementList)) {
      templateVo.setTemplateElements(templateElementList);
    }
    return templateVo;
  }

  /**
   * 根据模板编码查询详情
   *
   * @param code 模板编码
   * @return
   */
  @Override
  public ContractTemplateVo findDetailsByCode(String code) {
    if (StringUtils.isBlank(code)) {
      return null;
    }
    ContractTemplate entity = this.contractTemplateRepository.findByContractTemplateCode(code);
    if (entity == null) {
      return null;
    }
    ContractTemplateVo templateVo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            entity, ContractTemplateVo.class, HashSet.class, ArrayList.class);
    List<ContractTemplateElementVo> templateElementList =
        this.contractTemplateElementVoService.findByContractTemplateCode(
            templateVo.getTemplateCode());
    if (CollectionUtils.isNotEmpty(templateElementList)) {
      //通过要素编码去重 保证就算重复也会保证
      Map<String, List<ContractTemplateElementVo>> collect = templateElementList.stream()
          .collect(Collectors.groupingBy(ContractTemplateElementVo::getElementCode));
      List<ContractTemplateElementVo> list = new ArrayList<>();
      collect.forEach((k,v)->{
        list.add(v.get(0));
      });
      templateVo.setTemplateElements(list);
    }
    return templateVo;
  }
}
