package com.biz.crm.dms.business.contract.local.service.contracttemplateelement.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contracttemplateelement.ContractTemplateElement;
import com.biz.crm.dms.business.contract.local.repository.contracttemplateelement.ContractTemplateElementRepository;
import com.biz.crm.dms.business.contract.local.service.contracttemplateelement.ContractTemplateElementVoService;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement.ContractTemplateElementDto;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @description: 合同模板要素映射
 * @author: rentao
 * @date: 2021/11/18 14:32
 */
@Slf4j
@Service
public class ContractTemplateElementVoServiceImpl implements ContractTemplateElementVoService {

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false) private ContractTemplateElementRepository contractTemplateElementRepository;

  /**
   * 新增合同模板要素
   *
   * @param
   * @return
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveBatch(List<ContractTemplateElementDto> list, String contractTemplateCode) {
    Validate.notBlank(contractTemplateCode, "新增模板元组映射时，模板编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(list), "新增合同要素模板不能为空");
    List<ContractTemplateElement> elementList =
        (List<ContractTemplateElement>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                list,
                ContractTemplateElementDto.class,
                ContractTemplateElement.class,
                HashSet.class,
                ArrayList.class);
    elementList.forEach(
        entity -> {
          entity.setTemplateCode(contractTemplateCode);
          entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
          entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
    this.contractTemplateElementRepository.saveBatch(elementList);
  }


  /**
   * 编辑合同模板要素
   *
   * @param
   * @return
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateBatch(List<ContractTemplateElementDto> list, String contractTemplateCode) {
    Validate.notBlank(contractTemplateCode, "更新模板要素映射时，模板编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(list), "更新合同要素模板不能为空");
    // 删除之前模板要素映射关系
    this.contractTemplateElementRepository.deleteBytemplateCode(contractTemplateCode);
    // 保存最新数据
    List<ContractTemplateElement> elementList =
        (List<ContractTemplateElement>)
            this.nebulaToolkitService.copyCollectionByBlankList(
                list,
                ContractTemplateElementDto.class,
                ContractTemplateElement.class,
                HashSet.class,
                ArrayList.class);
    elementList.forEach(
        s -> {
          s.setId(null);
          s.setTemplateCode(contractTemplateCode);
        });
    this.contractTemplateElementRepository.saveBatch(elementList);
  }

  /**
   * 合同模板编码查询
   *
   * @param contractTemplateCode
   * @return
   */
  @Override
  public List<ContractTemplateElementVo> findByContractTemplateCode(String contractTemplateCode) {
    if (StringUtils.isBlank(contractTemplateCode)) {
      return null;
    }
    List<ContractTemplateElement> list =
        this.contractTemplateElementRepository.findByContractTemplateCode(contractTemplateCode);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    List<ContractTemplateElementVo> elementList =
        (List<ContractTemplateElementVo>)
            this.nebulaToolkitService.copyCollectionByBlankList(
                list,
                ContractTemplateElement.class,
                ContractTemplateElementVo.class,
                HashSet.class,
                ArrayList.class);
    return elementList;
  }
}
