package com.biz.crm.dms.business.contract.local.utils.contract;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Validate;

/**
 * @description: 合同
 * @author: rentao
 * @date: 2021/11/16 10:20
 */
public class ContractUtil {

  /**
   * 校验新增合同参数
   *
   * @param contractDto
   */
  public static void validateAdd(ContractDto contractDto) {
    Validate.notNull(contractDto, "合同信息不能为空");
    Validate.notBlank(contractDto.getContractName(), "合同名称不能为空");
    Validate.notBlank(contractDto.getTemplateCode(), "合同模板编码不能为空");
    Validate.notNull(contractDto.getElementDataMap(), "合同数据不能为空");
    Validate.notBlank(contractDto.getCusCode(), "客户编码不能为空");
    Validate.notBlank(contractDto.getContractType(), "合同类型不能为空");
    Validate.notBlank(contractDto.getContractYear(), "合同年度不能为空");
    Validate.notBlank(contractDto.getYearType(), "合同年度不能为空");
    Validate.notBlank(contractDto.getStartTime(), "合同有效开始时间不能为空");
    Validate.notBlank(contractDto.getEndTime(), "合同有效截止时间不能为空");
    Validate.isTrue(contractDto.getStartTime().compareTo(contractDto.getEndTime()) < 0, "开始时间必须小于结束时间");
    Date date=new Date();
    DateFormat format=new SimpleDateFormat("yyyy-MM-dd");
    Validate.isTrue(format.format(date).compareTo(contractDto.getEndTime()) < 0,"结束日期不能小于当前日期");
  }

  /**
   * 校验编辑合同参数
   *
   * @param contractDto
   */
  public static void validateEdit(ContractDto contractDto) {
    validateAdd(contractDto);
    Validate.notBlank(contractDto.getId(), "编辑时，合同id不能为空");
    Validate.notBlank(contractDto.getContractCode(), "编辑时，合同id不能为空");
  }

  /**
   * 校验合同签约参数
   *
   * @param contractVo
   */
  public static void validateSignContract(ContractVo contractVo) {
    Validate.notNull(contractVo, "合同详情为空");
    Validate.isTrue(Integer.valueOf(BooleanEnum.FALSE.getNumStr()).equals(contractVo.getCancellationState()), "合同已作废");
    Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(contractVo.getEnableStatus()), "合同已禁用");
    Validate.isTrue(DelFlagStatusEnum.NORMAL.getCode().equals(contractVo.getDelFlag()), "合同已删除");
    Validate.isTrue(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getDictCode().equals(contractVo.getContractStatus()), "合同不是待签约状态");
    Validate.isTrue(EffectiveStatusEnum.EFFECTIVE_STAY.getKey().equals(contractVo.getEffectiveStatus()), "合同不是待生效状态！");
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    String nowDate = format.format(new Date());
    Validate.isTrue(nowDate.compareTo(contractVo.getEndTime()) <= 0,"合同有效期已过不能签约！");
  }

  /** 计算日期 */
  public static void getExpireEminderDate(Contract entity) {
    if (BooleanEnum.TRUE.getNumStr().equals(entity.getExpirationReminder())) {
      SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
      Integer expirationReminderNum = entity.getExpirationReminderNum();
      Calendar calendar = Calendar.getInstance();
      try {
        calendar.setTime(format.parse(entity.getEndTime()));
        calendar.set(
            Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - expirationReminderNum);
        entity.setExpirationReminderDate(format.format(calendar.getTime()));
      } catch (ParseException e) {
        e.printStackTrace();
      }
    }
  }

}