package com.biz.crm.dms.business.contract.local.utils.contracttemplate;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement.ContractTemplateElementDto;
import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.enums.ContractYearType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @description: 合同模板工具类
 * @author: rentao
 * @date: 2021/11/17 14:36
 */
public class ContractTemplateUtil {

  /**
   * 校验新增合同模板参数
   *
   * @param dto
   */
  public static void validateAdd(ContractTemplateDto dto) {
    Validate.notNull(dto, "合同模板不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(dto.getTemplateElements()), "要素列表不能为空");
    Validate.notBlank(dto.getTemplateName(), "合同模板名称不能为空");
    Validate.notBlank(dto.getContractSignType(), "合同模板签署方式不能为空");
    Validate.notNull(ContractSignType.getByKey(dto.getContractSignType()), "合同签署方式传入数据不匹配");
    Validate.notBlank(dto.getYearType(), "合同模板年度类型不能为空");
    Validate.notNull(ContractYearType.getByKey(dto.getYearType()), "合同模板年度类型传入数据不匹配");
    //是否到期提醒
    Validate.notBlank(dto.getExpirationReminder(), "合同模板到期提醒不能为空");
    if (BooleanEnum.TRUE.getNumStr().equals(dto.getExpirationReminder())) {
      Validate.notNull(dto.getExpirationReminderNum(), "合同模板到期提醒天数不能为空");
      Validate.notNull(dto.getIndexPopup(),"首页是否弹出不能为空");
      Validate.notNull(dto.getEffectiveDay(),"有效天数不能为空");
      Validate.isTrue(dto.getEffectiveDay() > 0 ,"有效天数必须大于0");
      if(dto.getIndexPopup()){
        Validate.notBlank(dto.getPopupType(),"弹出类型不能为空");
      }
    } else {
      dto.setExpirationReminder(BooleanEnum.FALSE.getNumStr());
      dto.setExpirationReminderNum(null);
    }
    Validate.isTrue(dto.getTemplateName().length() <= 100, "合同模板名称长度不能超过64");
    if (StringUtils.isNotEmpty(dto.getContext())) {
      Validate.isTrue(dto.getContext().length() <= 500, "合同到期提示语不能超过500");
    }
    if (StringUtils.isNotEmpty(dto.getRemark())) {
      Validate.isTrue(dto.getRemark().length() <= 400, "合同模板备注不能超过400");
    }
    List<ContractTemplateElementDto> templateElements = dto.getTemplateElements();
    templateElements.forEach(tuple -> {
      Validate.notBlank(tuple.getElementCode(), "要素编码不能为空");
      Validate.notNull(tuple.getIndexCode(), "要素序号不能为空");
      Validate.notBlank(tuple.getElementName(), "要素对象名称不能为空");
      Validate.notBlank(tuple.getElementComponentName(),"要素组件名称不能为空");
    });
    Set<String> elementCodes = templateElements.stream().map(ContractTemplateElementDto::getElementCode).collect(Collectors.toSet());
    Set<Integer> indexCodes = templateElements.stream().map(ContractTemplateElementDto::getIndexCode).collect(Collectors.toSet());
    Validate.isTrue(templateElements.size() == elementCodes.size(), "合同要素模板编码重复");
    Validate.isTrue(templateElements.size() == indexCodes.size(), "合同要素排序重复");
  }

  /**
   * 校验编辑合同模板参数
   *
   * @param dto
   */
  public static void validateEdit(ContractTemplateDto dto) {
    validateAdd(dto);
    Validate.notBlank(dto.getId(), "编辑模板时，模板id不能为空");
    Validate.notBlank(dto.getTemplateCode(), "编辑模板时，模板编码不能为空");
  }

}
