/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.context.contractelement;

import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelement.ContractElementModelVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ContractElementContext {
    @Autowired(required=false)
    private List<ContractElementRegister> eventListeners;
    @Autowired(required=false)
    @Qualifier(value="contractSignBarRegister")
    private ContractElementRegister contractElementRegister;

    public List<ContractElementModelVo> getAllConfig(String contractSignType) {
        ArrayList<ContractElementModelVo> list = new ArrayList<ContractElementModelVo>();
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            this.eventListeners.forEach(s -> {
                if (!ContractSignType.ELECTRONIC_SIGNATURE.getDictCode().equals(contractSignType) && this.contractElementRegister.getContractElementCode().equals(s.getContractElementCode())) {
                    return;
                }
                ContractElementModelVo vo = new ContractElementModelVo();
                Validate.notNull((Object)s.getElementSort(), (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)s.getContractElementName(), (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)s.getContractElementCode(), (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)s.getContractElementComponentName(), (String)"\u5408\u540c\u8981\u7d20\u7ec4\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                vo.setElementSort(s.getElementSort());
                vo.setElementComponentName(s.getContractElementComponentName());
                vo.setElementName(s.getContractElementName());
                vo.setElementCode(s.getContractElementCode());
                vo.setRemark(s.getContractElementRemarks());
                list.add(vo);
            });
        }
        if (CollectionUtils.isNotEmpty(list)) {
            Collections.sort(list, new Comparator<ContractElementModelVo>(){

                @Override
                public int compare(ContractElementModelVo o1, ContractElementModelVo o2) {
                    return o1.getElementSort().compareTo(o2.getElementSort());
                }
            });
        }
        return list;
    }
}

