/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.controller.contract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.service.contract.ContractService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u7ba1\u7406: Contract \u5408\u540c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/contract/contract"})
public class ContractController {
    private static final Logger log = LoggerFactory.getLogger(ContractController.class);
    @Autowired(required=false)
    private ContractService contractService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Contract>> findByConditions(@PageableDefault(value=50) Pageable pageable, ContractDto contractDto) {
        return Result.ok(this.contractService.findByConditions(pageable, contractDto));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={""})
    public Result<Contract> create(@RequestBody ContractDto contractDto) {
        return Result.ok((Object)((Object)this.contractService.create(contractDto)));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<Contract> update(@RequestBody ContractDto contractDto) {
        return Result.ok((Object)((Object)this.contractService.update(contractDto)));
    }

    @ApiOperation(value="\u542f\u7528\u6a21\u677f")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        this.contractService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528\u6a21\u677f")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        this.contractService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5408\u540c\u7b7e\u7f72")
    @PatchMapping(value={"/signContract"})
    public Result<?> signContract(@RequestParam String contractCode) {
        this.contractService.signContract(contractCode);
        return Result.ok((String)"\u7b7e\u7f72\u6210\u529f");
    }

    @ApiOperation(value="\u5408\u540c\u7b7e\u7f72")
    @PostMapping(value={"/signContractTurnPatch"})
    public Result<?> signContractTurnPatch(@RequestParam String contractCode) {
        this.contractService.signContract(contractCode);
        return Result.ok((String)"\u7b7e\u7f72\u6210\u529f");
    }

    @ApiOperation(value="\u5408\u540c\u4f5c\u5e9f")
    @PatchMapping(value={"/cancellation"})
    public Result<?> cancellation(@RequestParam String contractCode) {
        this.contractService.cancellation(contractCode);
        return Result.ok((String)"\u4f5c\u5e9f\u6210\u529f");
    }

    @ApiOperation(value="\u5408\u540c\u63a8\u9001")
    @PatchMapping(value={"/handlePush"})
    public Result<?> handlePush(@RequestParam String contractCode) {
        this.contractService.handlePush(contractCode);
        return Result.ok((String)"\u5408\u540c\u63a8\u9001");
    }
}

