/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.repository.contract;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.mapper.contract.ContractMapper;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.ContractCancellationState;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ContractRepository
extends ServiceImpl<ContractMapper, Contract> {
    public Page<Contract> findByConditions(Page<Contract> pageable, @Param(value="dto") ContractDto dto) {
        return ((ContractMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public Contract findByContractCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return (Contract)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Contract::getContractCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<Contract> findByContractCodes(List<String> contractCodes) {
        if (CollectionUtils.isEmpty(contractCodes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Contract::getContractCode, contractCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<Contract> findByTemplateCode(List<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Contract::getTemplateCode, templateCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<Contract> findByStartTime(String dateTime) {
        if (StringUtils.isEmpty((CharSequence)dateTime)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(Contract::getStartTime, (Object)dateTime)).ge(Contract::getEndTime, (Object)dateTime)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Contract::getEffectiveStatus, (Object)EffectiveStatusEnum.EFFECTIVE_STAY.getDictCode())).eq(Contract::getCancellationState, (Object)ContractCancellationState.CANCELLATION.getDictCode())).eq(Contract::getContractStatus, (Object)ActApproveStatusExtendEnum.SIGN_CONTRACT.getDictCode())).list();
    }

    public List<Contract> findByEndTime(String dateTime) {
        if (StringUtils.isEmpty((CharSequence)dateTime)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(Contract::getEndTime, (Object)dateTime)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<Contract> findByExpireEminderDate(String expireEminderDate) {
        if (StringUtils.isEmpty((CharSequence)expireEminderDate)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Contract::getExpirationReminderDate, (Object)expireEminderDate)).eq(Contract::getContractStatus, (Object)ActApproveStatusExtendEnum.SIGN_CONTRACT.getKey())).eq(Contract::getCancellationState, (Object)Integer.valueOf(BooleanEnum.FALSE.getNumStr()))).eq(Contract::getExpirationReminder, (Object)BooleanEnum.TRUE.getNumStr())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).update();
    }

    public void updateSignStateById(String contractStatus, String effectiveStatus, String contractCode) {
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Contract::getContractStatus, (Object)contractStatus)).set(Contract::getEffectiveStatus, (Object)effectiveStatus)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Contract::getContractCode, (Object)contractCode)).update();
    }

    public void updateCancellationStateByContractCode(Integer cancellationState, String contractCode) {
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Contract::getCancellationState, (Object)cancellationState)).eq(Contract::getContractCode, (Object)contractCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public Page<Contract> findByContractCustomerDto(Page<Contract> pageable, ContractCustomerDto contractCustomerDto) {
        return ((ContractMapper)this.baseMapper).findByContractCustomerDto(pageable, contractCustomerDto);
    }

    public Contract findByContractProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return (Contract)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Contract::getProcessNumber, (Object)processNo)).one());
    }

    public void updateContractStatusByContractCode(String contractStatus, String contractCode) {
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Contract::getContractStatus, (Object)contractStatus)).eq(Contract::getContractCode, (Object)contractCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public Integer findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto) {
        contractCustomerDto.setTenantCode(TenantUtils.getTenantCode());
        return ((ContractMapper)this.baseMapper).findUnsignedCountByCurrentCustomer(contractCustomerDto);
    }

    public List<Contract> findByCustomerCodeAndEffectiveStatus(String customerCode, String effectiveStatus) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Contract::getCusCode, (Object)customerCode)).eq(Contract::getEffectiveStatus, (Object)effectiveStatus)).list();
        return list;
    }
}

