/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.contract.local.entity.contract.ContractAdditionalFile;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractAdditionalFileRepository;
import com.biz.crm.dms.business.contract.local.service.contract.ContractAdditionalFileService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractAdditionalFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="contractAdditionalFileService")
public class ContractAdditionalFileServiceImpl
implements ContractAdditionalFileService {
    private static final Logger log = LoggerFactory.getLogger(ContractAdditionalFileServiceImpl.class);
    @Autowired
    private ContractAdditionalFileRepository contractAdditionalFileRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public void create(List<ContractAdditionalFileDto> dtoList) {
        this.createValidation(dtoList);
        ArrayList fileList = Lists.newArrayList();
        Set<String> contractIds = dtoList.stream().map(ContractAdditionalFileDto::getContractId).collect(Collectors.toSet());
        this.contractAdditionalFileRepository.deleteByContractIds(contractIds);
        dtoList.forEach(typeFileDto -> {
            if (CollectionUtils.isEmpty((Collection)typeFileDto.getFileList())) {
                return;
            }
            typeFileDto.getFileList().forEach(fileDto -> {
                ContractAdditionalFile file = (ContractAdditionalFile)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList(fileDto, ContractAdditionalFile.class, HashSet.class, ArrayList.class, new String[0]))));
                file.setContractId(typeFileDto.getContractId());
                file.setFileType(typeFileDto.getFileType());
                file.setAdditionalFileCode((String)this.generateCodeService.generateCode("CAF", 1).get(0));
                file.setTenantCode(typeFileDto.getTenantCode());
                file.setSortIndex(typeFileDto.getFileList().indexOf(fileDto));
                fileList.add(file);
            });
        });
        if (!CollectionUtils.isEmpty((Collection)fileList)) {
            this.contractAdditionalFileRepository.saveBatch(fileList);
        }
    }

    private void createValidation(List<ContractAdditionalFileDto> dtoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtoList) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dtoList.forEach(typeFileDto -> {
            Validate.notBlank((CharSequence)typeFileDto.getContractId(), (String)"\u7f3a\u5931\u5408\u540cID", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)typeFileDto.getFileType(), (String)"\u7f3a\u5931\u6587\u4ef6\u7c7b\u578b", (Object[])new Object[0]);
            typeFileDto.setTenantCode(TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty((Collection)typeFileDto.getFileList())) {
                typeFileDto.getFileList().forEach(fileDto -> Validate.notBlank((CharSequence)fileDto.getAdditionalTypeKey(), (String)"\u7f3a\u5931\u9644\u52a0\u7c7b\u578bkey", (Object[])new Object[0]));
            }
        });
    }
}

