/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.contract.local.entity.contract.ContractAdditionalFile;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractAdditionalFileRepository;
import com.biz.crm.dms.business.contract.sdk.register.contract.ContractAdditionalFileRegister;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileInfoVo;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractAdditionalFileVoServiceImpl
implements ContractAdditionalFileVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractAdditionalFileVoServiceImpl.class);
    @Autowired
    private ContractAdditionalFileRepository contractAdditionalFileRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ContractAdditionalFileRegister> registers;

    public List<ContractAdditionalFileVo> findByContractId(String contractId) {
        if (StringUtils.isBlank((CharSequence)contractId)) {
            return Lists.newLinkedList();
        }
        List<ContractAdditionalFile> additionalFiles = this.contractAdditionalFileRepository.findByContractId(contractId);
        if (CollectionUtils.isEmpty(additionalFiles)) {
            return Lists.newLinkedList();
        }
        Set additionalFileCodes = additionalFiles.stream().map(ContractAdditionalFile::getAdditionalFileCode).collect(Collectors.toSet());
        HashMap additionalMap = Maps.newHashMap();
        this.registers.forEach(register -> {
            Map map = (Map)ObjectUtils.defaultIfNull((Object)register.onRequestByAdditionalFileCodes(additionalFileCodes), (Object)Maps.newHashMap());
            map.forEach(additionalMap::put);
        });
        HashMap typeFileMap = Maps.newHashMap();
        additionalFiles.forEach(additionalFile -> {
            ContractAdditionalFileVo typeFileVo = (ContractAdditionalFileVo)typeFileMap.get(additionalFile.getFileType());
            if (Objects.isNull(typeFileVo)) {
                typeFileVo = new ContractAdditionalFileVo();
                typeFileVo.setContractId(additionalFile.getContractId());
                typeFileVo.setFileType(additionalFile.getFileType());
                typeFileVo.setFileList((List)Lists.newArrayList());
            }
            ContractAdditionalFileInfoVo fileVo = (ContractAdditionalFileInfoVo)this.nebulaToolkitService.copyObjectByBlankList((Object)additionalFile, ContractAdditionalFileInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            fileVo.setAdditionalJson((JSONObject)additionalMap.get(fileVo.getAdditionalTypeKey()));
            typeFileVo.getFileList().add(fileVo);
            typeFileMap.put(additionalFile.getFileType(), typeFileVo);
        });
        return Lists.newArrayList(typeFileMap.values());
    }
}

