/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.entity.contracthtml.ContractHtmlEntity;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.local.repository.contracthtml.ContractHtmlRepository;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileVoService;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ContractVoServiceImpl
implements ContractVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractVoServiceImpl.class);
    @Autowired(required=false)
    private ContractRepository contractRepository;
    @Autowired(required=false)
    private ContractHtmlRepository contractHtmlRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ContractElementService contractElementService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ContractAdditionalFileVoService contractAdditionalFileVoService;

    public ContractVo findById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u4f20\u5165\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Contract contract = (Contract)((Object)this.contractRepository.getById((Serializable)((Object)id)));
        if (contract == null) {
            return null;
        }
        ContractVo vo = (ContractVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contract, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
        return this.assemblyDetails(vo);
    }

    public List<ContractVo> findByContractCodes(List<String> contractCodes) {
        List<Contract> list = this.contractRepository.findByContractCodes(contractCodes);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public ContractVo findDetailsByCode(String code) {
        Validate.notEmpty((CharSequence)code, (String)"\u4f20\u5165\u5408\u540c\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Contract contract = this.contractRepository.findByContractCode(code);
        if (contract == null) {
            return null;
        }
        ContractVo vo = (ContractVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contract, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
        return this.assemblyDetails(vo);
    }

    public List<ContractVo> findByTemplateCode(List<String> templateCodes) {
        List<Contract> contracts = this.contractRepository.findByTemplateCode(templateCodes);
        if (CollectionUtils.isEmpty(contracts)) {
            return null;
        }
        List contractVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contracts, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
        return contractVos;
    }

    public Page<ContractVo> findByContractCustomerDto(Pageable pageable, ContractCustomerDto contractCustomerDto) {
        String customerCode = contractCustomerDto.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            Page pageResult = new Page(0L, 0L, 0L);
            return pageResult;
        }
        contractCustomerDto.setCusCode(customerCode);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        contractCustomerDto = (ContractCustomerDto)ObjectUtils.defaultIfNull((Object)contractCustomerDto, (Object)new ContractCustomerDto());
        contractCustomerDto.setTenantCode(TenantUtils.getTenantCode());
        Page<Contract> entityResult = this.contractRepository.findByContractCustomerDto((Page<Contract>)page, contractCustomerDto);
        Page pageResult = new Page(entityResult.getCurrent(), entityResult.getSize(), entityResult.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityResult.getRecords())) {
            return pageResult;
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityResult.getRecords(), Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]));
        pageResult.setRecords((List)list);
        return pageResult;
    }

    public Integer findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto) {
        String customerCode = contractCustomerDto.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return 0;
        }
        contractCustomerDto.setCusCode(customerCode);
        contractCustomerDto.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getDictCode());
        return this.contractRepository.findUnsignedCountByCurrentCustomer(contractCustomerDto);
    }

    public List<ContractVo> findEffectiveByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        String effectiveStatus = EffectiveStatusEnum.EFFECTIVE_ACTIVE.getDictCode();
        List<Contract> list = this.contractRepository.findByCustomerCodeAndEffectiveStatus(customerCode, effectiveStatus);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
        return voList;
    }

    private ContractVo assemblyDetails(ContractVo vo) {
        HashMap<String, JSONObject> elementDataMap = new HashMap<String, JSONObject>();
        elementDataMap.putAll(this.contractElementService.findContractElement(vo));
        elementDataMap.putAll(this.contractElementService.findInitiativeContractElement(vo));
        vo.setElementDataMap(elementDataMap);
        ContractHtmlEntity contractHtmlEntity = this.contractHtmlRepository.findByContractCode(vo.getContractCode());
        if (Objects.nonNull((Object)contractHtmlEntity)) {
            vo.setHtmlStr(contractHtmlEntity.getHtmlStr());
        }
        vo.setAdditionalFileList(this.contractAdditionalFileVoService.findByContractId(vo.getId()));
        return vo;
    }
}

