/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractEventDto;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractManagementEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContractManagementEventListenerImpl
implements ContractManagementEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.CREATE);
    }

    public void onUpdate(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
    }

    public void onDelete(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.DELETE);
    }

    public void onEnable(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
    }

    public void onDisable(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
    }

    public void onCancellation(ContractEventDto contractEventDto) {
        this.handleUpdate(contractEventDto, OperationTypeEunm.UPDATE);
    }

    public void handleUpdate(ContractEventDto contractEventDto, OperationTypeEunm operationTypeEunm) {
        Object original = contractEventDto.getOriginal();
        Object newest = contractEventDto.getNewest();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
        crmBusinessLogDto.setOnlyKey(contractEventDto.getOnlyKey());
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

