/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessCompleteListenerOfContract
implements ProcessCompleteListener {
    @Autowired(required=false)
    private ContractRepository contractRepository;

    public String getBusinessCode() {
        return "contract";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!"contract".equals(dto.getBusinessCode())) {
            return;
        }
        Contract contract = this.contractRepository.findByContractProcessNo(dto.getProcessNo());
        if (ObjectUtils.isEmpty((Object)((Object)contract))) {
            return;
        }
        Validate.isTrue((boolean)contract.getContractStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()), (String)"\u6b64\u8ba2\u5355\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        contract.setContractStatus(dto.getProcessStatus());
        if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
            contract.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getKey());
        }
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(dto.getProcessStatus())) {
            contract.setContractStatus(ProcessStatusEnum.PREPARE.getDictCode());
            contract.setProcessNumber(null);
            contract.setProcessRemark(null);
        }
        this.contractRepository.updateById((Object)contract);
    }
}

