/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractarea.internal;

import com.biz.crm.dms.business.contract.local.entity.contractarea.ContractArea;
import com.biz.crm.dms.business.contract.local.repository.contractarea.ContractAreaRepository;
import com.biz.crm.dms.business.contract.local.service.contractarea.ContractAreaDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractarea.ContractAreaVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAreaDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractAreaDataVoServiceImpl
implements ContractAreaDataVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractAreaDataVoServiceImpl.class);
    @Autowired(required=false)
    private ContractAreaRepository contractAreaRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractAreaDataVo findByContractCode(String contractcode) {
        if (StringUtils.isBlank((CharSequence)contractcode)) {
            return null;
        }
        List<ContractArea> contractAreas = this.contractAreaRepository.findByContractCode(contractcode);
        if (CollectionUtils.isEmpty(contractAreas)) {
            return null;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contractAreas, ContractArea.class, ContractAreaVo.class, HashSet.class, ArrayList.class, new String[0]);
        ContractAreaDataVo vo = new ContractAreaDataVo();
        vo.setContractAreaVos(voList);
        return vo;
    }

    @Override
    @Transactional
    public ContractAreaDataVo createContractDetailsElement(String contractCode, ContractAreaDataVo contractAreaDataVo, Integer indexCode) {
        this.ValidateSaveOrUpdate(contractCode, contractAreaDataVo);
        List contractAreaVos = contractAreaDataVo.getContractAreaVos();
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contractAreaVos, ContractAreaVo.class, ContractArea.class, HashSet.class, ArrayList.class, new String[0]);
        this.contractAreaRepository.saveBatch(voList);
        return contractAreaDataVo;
    }

    @Override
    @Transactional
    public ContractAreaDataVo updateContractDetailsElement(String contractCode, ContractAreaDataVo contractAreaDataVo, Integer indexCode) {
        this.ValidateSaveOrUpdate(contractCode, contractAreaDataVo);
        this.contractAreaRepository.deleteByContractCode(contractCode);
        List contractAreaVos = contractAreaDataVo.getContractAreaVos();
        List contractAreas = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contractAreaVos, ContractAreaVo.class, ContractArea.class, HashSet.class, ArrayList.class, new String[0]);
        contractAreas.forEach(contractArea -> contractArea.setId(null));
        this.contractAreaRepository.saveBatch(contractAreas);
        return contractAreaDataVo;
    }

    private void ValidateSaveOrUpdate(String contractCode, ContractAreaDataVo contractAreaDataVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractAreaDataVo, (String)"\u5408\u540c\u9500\u552e\u533a\u57df\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)contractAreaDataVo.getContractAreaVos()), (String)"\u5408\u540c\u9500\u552e\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List contractAreaVos = contractAreaDataVo.getContractAreaVos();
        contractAreaVos.forEach(contractAreaVo -> {
            Validate.notBlank((CharSequence)contractAreaVo.getProvinceCode(), (String)"\u7701\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractAreaVo.getCityCode(), (String)"\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractAreaVo.getDistrictCode(), (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contractAreaVo.setContractCode(contractCode);
        });
    }
}

