/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractdetailselement.internal;

import com.biz.crm.dms.business.contract.local.entity.contractdetailselement.ContractDetailsElement;
import com.biz.crm.dms.business.contract.local.repository.contractdetailselement.ContractDetailsElementRepository;
import com.biz.crm.dms.business.contract.local.service.contractdetailselement.ContractDetailsElementDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractDetailsElementDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractDetailsElementDataVoServiceImpl
implements ContractDetailsElementDataVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractDetailsElementDataVoServiceImpl.class);
    @Autowired(required=false)
    private ContractDetailsElementRepository contractDetailsElementRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractDetailsElementDataVo findByContractCode(String contractcode) {
        ContractDetailsElement contractDetailsElement = this.contractDetailsElementRepository.findByContractCode(contractcode);
        if (Objects.isNull((Object)contractDetailsElement)) {
            return null;
        }
        ContractDetailsElementDataVo vo = (ContractDetailsElementDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractDetailsElement, ContractDetailsElementDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    @Override
    @Transactional
    public ContractDetailsElementDataVo createContractDetailsElement(String contractCode, ContractDetailsElementDataVo contractDetailsElementDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractDetailsElementDataVo);
        ContractDetailsElement contractDetailsElement = (ContractDetailsElement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractDetailsElementDataVo, ContractDetailsElement.class, HashSet.class, ArrayList.class, new String[0]));
        contractDetailsElement.setContractCode(contractCode);
        this.contractDetailsElementRepository.save((Object)contractDetailsElement);
        return contractDetailsElementDataVo;
    }

    @Override
    @Transactional
    public ContractDetailsElementDataVo updateContractDetailsElement(String contractCode, ContractDetailsElementDataVo contractDetailsElementDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractDetailsElementDataVo);
        ContractDetailsElement contractDetailsElement = this.contractDetailsElementRepository.findByContractCode(contractCode);
        Validate.notNull((Object)((Object)contractDetailsElement), (String)"\u5408\u540c\u8fdd\u7ea6\u8d23\u4efb\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ContractDetailsElement detailsElement = (ContractDetailsElement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractDetailsElementDataVo, ContractDetailsElement.class, HashSet.class, ArrayList.class, new String[0]));
        detailsElement.setContractCode(contractCode);
        detailsElement.setId(contractDetailsElement.getId());
        this.contractDetailsElementRepository.updateById((Object)detailsElement);
        return contractDetailsElementDataVo;
    }

    private void validateSaveOrUpdate(String contractCode, ContractDetailsElementDataVo contractDetailsElementDataVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractDetailsElementDataVo, (String)"\u5408\u540c\u7ec6\u5219\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDetailsElementDataVo.getContractDetails(), (String)"\u5408\u540c\u7ec6\u5219\u4e3a\u7a7a\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((contractDetailsElementDataVo.getContractDetails().length() <= 20000 ? 1 : 0) != 0, (String)"\u5408\u540c\u7ec6\u5219\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720000", (Object[])new Object[0]);
    }
}

