/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractelement.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementService;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractElementDataVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractElementServiceImpl
implements ContractElementService {
    private static final Logger log = LoggerFactory.getLogger(ContractElementServiceImpl.class);
    @Autowired(required=false)
    private ContractTemplateVoService contractTemplateVoService;
    @Autowired(required=false)
    private List<ContractElementRegister> elementRegisters;

    @Override
    public Map<String, JSONObject> findInitiativeContractElement(ContractVo contractVo) {
        Validate.notNull((Object)contractVo, (String)"\u4f20\u5165\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractVo.getTemplateCode(), (String)"\u4f20\u5165\u5408\u540c\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        ContractTemplateVo templateVo = this.contractTemplateVoService.findDetailsByCode(contractVo.getTemplateCode());
        Validate.notNull((Object)templateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6a21\u677f", (Object[])new Object[0]);
        HashMap<String, JSONObject> elementDataMap = new HashMap<String, JSONObject>();
        List elementModelVos = templateVo.getTemplateElements();
        if (CollectionUtils.isNotEmpty((Collection)elementModelVos) && CollectionUtils.isNotEmpty(this.elementRegisters)) {
            for (ContractTemplateElementVo templateElementVo : elementModelVos) {
                List contractElementRegisters = this.elementRegisters.stream().filter(elementRegister -> elementRegister.getContractElementCode().equals(templateElementVo.getElementCode())).collect(Collectors.toList());
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty(contractElementRegisters), (String)"\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                ContractElementRegister contractElementRegister = (ContractElementRegister)contractElementRegisters.get(0);
                ContractElementDataVo contractElementDateVo = contractElementRegister.onRequestContractElement(contractVo);
                if (!Objects.nonNull(contractElementDateVo)) continue;
                elementDataMap.put(templateElementVo.getElementCode(), JsonUtils.toJSONObject((Object)contractElementDateVo));
            }
        }
        return elementDataMap;
    }

    @Override
    public Map<String, JSONObject> findContractElement(ContractVo contractVo) {
        ContractTemplateVo templateVo = this.contractTemplateVoService.findDetailsByCode(contractVo.getTemplateCode());
        Validate.notNull((Object)templateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6a21\u677f", (Object[])new Object[0]);
        HashMap<String, JSONObject> elementDataMap = new HashMap<String, JSONObject>();
        List elementModelVos = templateVo.getTemplateElements();
        if (CollectionUtils.isNotEmpty((Collection)elementModelVos) && CollectionUtils.isNotEmpty(this.elementRegisters)) {
            for (ContractTemplateElementVo templateElementVo : elementModelVos) {
                List contractElementRegisters = this.elementRegisters.stream().filter(elementRegister -> elementRegister.getContractElementCode().equals(templateElementVo.getElementCode())).collect(Collectors.toList());
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty(contractElementRegisters), (String)"\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                ContractElementRegister contractElementRegister = (ContractElementRegister)contractElementRegisters.get(0);
                ContractElementDataVo contractElementDateVo = contractElementRegister.getByContractCode(contractVo.getContractCode());
                elementDataMap.put(templateElementVo.getElementCode(), JsonUtils.toJSONObject((Object)contractElementDateVo));
            }
        }
        return elementDataMap;
    }
}

