/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractliability.internal;

import com.biz.crm.dms.business.contract.local.entity.contractliability.ContractLiability;
import com.biz.crm.dms.business.contract.local.repository.contractliability.ContractLiabilityRepository;
import com.biz.crm.dms.business.contract.local.service.contractliability.ContractLiabilityDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractLiabilityDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractLiabilityDataVoServiceImpl
implements ContractLiabilityDataVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractLiabilityDataVoServiceImpl.class);
    @Autowired(required=false)
    private ContractLiabilityRepository contractLiabilityRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractLiabilityDataVo findByContractCode(String contractcode) {
        ContractLiability contractLiability = this.contractLiabilityRepository.findByContractCode(contractcode);
        if (Objects.isNull((Object)contractLiability)) {
            return null;
        }
        ContractLiabilityDataVo vo = (ContractLiabilityDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractLiability, ContractLiabilityDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    @Override
    @Transactional
    public ContractLiabilityDataVo createContractLiability(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractLiabilityDataVo);
        ContractLiability contractLiability = (ContractLiability)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractLiabilityDataVo, ContractLiability.class, HashSet.class, ArrayList.class, new String[0]));
        contractLiability.setContractCode(contractCode);
        this.contractLiabilityRepository.save((Object)contractLiability);
        return contractLiabilityDataVo;
    }

    @Override
    @Transactional
    public ContractLiabilityDataVo updateContractLiability(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractLiabilityDataVo);
        ContractLiability liability = this.contractLiabilityRepository.findByContractCode(contractCode);
        Validate.notNull((Object)((Object)liability), (String)"\u5408\u540c\u8fdd\u7ea6\u8d23\u4efb\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ContractLiability contractLiability = (ContractLiability)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractLiabilityDataVo, ContractLiability.class, HashSet.class, ArrayList.class, new String[0]));
        contractLiability.setContractCode(contractCode);
        contractLiability.setId(liability.getId());
        this.contractLiabilityRepository.updateById((Object)contractLiability);
        return contractLiabilityDataVo;
    }

    private void validateSaveOrUpdate(String contractCode, ContractLiabilityDataVo contractLiabilityDataVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractLiabilityDataVo, (String)"\u5408\u540c\u8fdd\u7ea6\u8d23\u4efb\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractLiabilityDataVo.getContractLiability(), (String)"\u5408\u540c\u8fdd\u7ea6\u8d23\u4efb\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((contractLiabilityDataVo.getContractLiability().length() <= 20000 ? 1 : 0) != 0, (String)"\u5408\u540c\u8fdd\u7ea6\u8d23\u4efb\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720000", (Object[])new Object[0]);
    }
}

