/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractsignbar.internal;

import com.biz.crm.dms.business.contract.local.entity.contractsignbar.ContractSignBar;
import com.biz.crm.dms.business.contract.local.repository.contractsignbar.ContractSignBarRepository;
import com.biz.crm.dms.business.contract.local.service.contractsignbar.ContractSignBarDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractSignBarDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractSignBarDataVoServiceImpl
implements ContractSignBarDataVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignBarDataVoServiceImpl.class);
    @Autowired(required=false)
    private ContractSignBarRepository contractSignBarRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractSignBarDataVo findByContractCode(String contractcode) {
        ContractSignBar contractSignBar = this.contractSignBarRepository.findByContractCode(contractcode);
        if (Objects.isNull((Object)contractSignBar)) {
            return null;
        }
        ContractSignBarDataVo vo = (ContractSignBarDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractSignBar, ContractSignBarDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    @Override
    @Transactional
    public ContractSignBarDataVo createContractSignBar(String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractSignBarDataVo);
        ContractSignBar contractSignBar = (ContractSignBar)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractSignBarDataVo, ContractSignBar.class, HashSet.class, ArrayList.class, new String[0]));
        contractSignBar.setContractCode(contractCode);
        this.contractSignBarRepository.save((Object)contractSignBar);
        return contractSignBarDataVo;
    }

    @Override
    @Transactional
    public ContractSignBarDataVo updateContractSignBar(String contractCode, ContractSignBarDataVo contractSignBarDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, contractSignBarDataVo);
        ContractSignBar signBar = this.contractSignBarRepository.findByContractCode(contractCode);
        Validate.notNull((Object)((Object)signBar), (String)"\u5408\u540c\u7b7e\u7f72\u680f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ContractSignBar contractSignBar = (ContractSignBar)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractSignBarDataVo, ContractSignBar.class, HashSet.class, ArrayList.class, new String[0]));
        contractSignBar.setContractCode(contractCode);
        contractSignBar.setId(signBar.getId());
        this.contractSignBarRepository.updateById((Object)contractSignBar);
        return contractSignBarDataVo;
    }

    private void validateSaveOrUpdate(String contractCode, ContractSignBarDataVo contractSignBarDataVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractSignBarDataVo, (String)"\u5408\u540c\u7b7e\u7f72\u680f\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSignBarDataVo.getFirstPartyName(), (String)"\u5408\u540c\u7532\u65b9\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((contractSignBarDataVo.getFirstPartyName().length() <= 30 ? 1 : 0) != 0, (String)"\u5408\u540c\u7532\u65b9\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc730\u5b57\u7b26", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSignBarDataVo.getFirstPartySignDate(), (String)"\u5408\u540c\u7532\u65b9\u7b7e\u7f72\u65e5\u671f\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSignBarDataVo.getSecondPartyName(), (String)"\u5408\u540c\u4e59\u65b9\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((contractSignBarDataVo.getSecondPartyName().length() <= 30 ? 1 : 0) != 0, (String)"\u5408\u540c\u4e59\u65b9\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc730\u5b57\u7b26", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractSignBarDataVo.getSecondPartySignDate(), (String)"\u5408\u540c\u4e59\u65b9\u7b7e\u7f72\u65e5\u671f\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

