/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contracttemplateelement.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contracttemplateelement.ContractTemplateElement;
import com.biz.crm.dms.business.contract.local.repository.contracttemplateelement.ContractTemplateElementRepository;
import com.biz.crm.dms.business.contract.local.service.contracttemplateelement.ContractTemplateElementVoService;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement.ContractTemplateElementDto;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractTemplateElementVoServiceImpl
implements ContractTemplateElementVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractTemplateElementVoServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ContractTemplateElementRepository contractTemplateElementRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<ContractTemplateElementDto> list, String contractTemplateCode) {
        Validate.notBlank((CharSequence)contractTemplateCode, (String)"\u65b0\u589e\u6a21\u677f\u5143\u7ec4\u6620\u5c04\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u65b0\u589e\u5408\u540c\u8981\u7d20\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List elementList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ContractTemplateElementDto.class, ContractTemplateElement.class, HashSet.class, ArrayList.class, new String[0]);
        elementList.forEach(entity -> {
            entity.setTemplateCode(contractTemplateCode);
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.contractTemplateElementRepository.saveBatch(elementList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatch(List<ContractTemplateElementDto> list, String contractTemplateCode) {
        Validate.notBlank((CharSequence)contractTemplateCode, (String)"\u66f4\u65b0\u6a21\u677f\u8981\u7d20\u6620\u5c04\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u66f4\u65b0\u5408\u540c\u8981\u7d20\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.contractTemplateElementRepository.deleteBytemplateCode(contractTemplateCode);
        List elementList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ContractTemplateElementDto.class, ContractTemplateElement.class, HashSet.class, ArrayList.class, new String[0]);
        elementList.forEach(s -> {
            s.setId(null);
            s.setTemplateCode(contractTemplateCode);
        });
        this.contractTemplateElementRepository.saveBatch(elementList);
    }

    @Override
    public List<ContractTemplateElementVo> findByContractTemplateCode(String contractTemplateCode) {
        if (StringUtils.isBlank((CharSequence)contractTemplateCode)) {
            return null;
        }
        List<ContractTemplateElement> list = this.contractTemplateElementRepository.findByContractTemplateCode(contractTemplateCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List elementList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ContractTemplateElement.class, ContractTemplateElementVo.class, HashSet.class, ArrayList.class, new String[0]);
        return elementList;
    }
}

